/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.geotools.api.data.DataStore;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.sqlserver.SQLServerDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import org.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.json.JDBCConnectionProperties;
import org.tailormap.api.persistence.json.ServiceAuthentication;

public class JDBCFeatureSourceHelper
extends FeatureSourceHelper {
    private static final Map<JDBCConnectionProperties.DbtypeEnum, Integer> defaultPorts = Map.of(JDBCConnectionProperties.DbtypeEnum.POSTGIS, 5432, JDBCConnectionProperties.DbtypeEnum.ORACLE, 1521, JDBCConnectionProperties.DbtypeEnum.SQLSERVER, 1433);

    public DataStore createDataStore(TMFeatureSource tmfs, Integer timeout) throws IOException {
        if (tmfs.getProtocol() != TMFeatureSource.Protocol.JDBC) {
            throw new IllegalArgumentException(tmfs.getProtocol().getValue());
        }
        Objects.requireNonNull(tmfs.getJdbcConnection());
        Objects.requireNonNull(tmfs.getAuthentication());
        if (tmfs.getAuthentication().getMethod() != ServiceAuthentication.MethodEnum.PASSWORD) {
            throw new IllegalArgumentException(tmfs.getAuthentication().getMethod().getValue());
        }
        JDBCConnectionProperties c = tmfs.getJdbcConnection();
        Objects.requireNonNull(c.getDbtype());
        Object connectionOpts = Optional.ofNullable((String)c.getAdditionalProperties().get("connectionOptions")).orElse("");
        HashMap<String, Object> params = new HashMap<String, Object>();
        switch (1.$SwitchMap$org$tailormap$api$persistence$json$JDBCConnectionProperties$DbtypeEnum[c.getDbtype().ordinal()]) {
            case 1: {
                params.put(PostgisNGDataStoreFactory.ESTIMATED_EXTENTS.key, true);
                if (((String)connectionOpts).contains("ApplicationName")) break;
                connectionOpts = (String)connectionOpts + (((String)connectionOpts).contains("?") ? "&amp;" : "?") + "ApplicationName=tailormap-api";
                break;
            }
            case 2: {
                params.put(SQLServerDataStoreFactory.ESTIMATED_EXTENTS.key, true);
                params.put(SQLServerDataStoreFactory.GEOMETRY_METADATA_TABLE.key, "geometry_columns");
                if (((String)connectionOpts).contains("applicationName")) break;
                connectionOpts = (String)connectionOpts + ";applicationName=tailormap-api";
                break;
            }
        }
        params.put(JDBCDataStoreFactory.DBTYPE.key, c.getDbtype().getValue());
        params.put(JDBCDataStoreFactory.HOST.key, c.getHost());
        params.put(JDBCDataStoreFactory.PORT.key, c.getPort() != null ? c.getPort() : (Integer)defaultPorts.get(c.getDbtype()));
        params.put(JDBCDataStoreFactory.DATABASE.key, c.getDatabase() + (String)connectionOpts);
        params.put(JDBCDataStoreFactory.SCHEMA.key, c.getSchema());
        params.put(JDBCDataStoreFactory.USER.key, tmfs.getAuthentication().getUsername());
        params.put(JDBCDataStoreFactory.PASSWD.key, tmfs.getAuthentication().getPassword());
        params.put(JDBCDataStoreFactory.FETCHSIZE.key, c.getFetchSize());
        params.put(JDBCDataStoreFactory.EXPOSE_PK.key, true);
        params.put(JDBCDataStoreFactory.PK_METADATA_TABLE.key, c.getPrimaryKeyMetadataTable());
        params.put(JDBCDataStoreFactory.MAXWAIT.key, timeout);
        return this.openDatastore(params, JDBCDataStoreFactory.PASSWD.key);
    }
}

