/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.json.AppI18nSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AppUiSettings;
import org.tailormap.api.persistence.json.FilterGroup;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.repository.GeoServiceRepository;
import org.tailormap.api.security.AuthorisationService;
import org.tailormap.api.viewer.model.ViewerResponse;

@Service
public class ViewerHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GeoServiceRepository geoServiceRepository;
    private final AuthorisationService authorisationService;

    public ViewerHelper(GeoServiceRepository geoServiceRepository, AuthorisationService authorisationService) {
        this.geoServiceRepository = geoServiceRepository;
        this.authorisationService = authorisationService;
    }

    public ViewerResponse getViewerResponse(Application application) {
        List<FilterGroup> allowedFilterGroups = application.getSettings().getFilterGroups().stream().filter(fg -> {
            ArrayList<String> allowedLayerIds = new ArrayList<String>();
            for (String layerId : fg.getLayerIds()) {
                GeoServiceLayer layer;
                GeoService service;
                AppTreeLayerNode lyrNode = application.getAllAppTreeLayerNode().filter(node -> node.getId().equals(layerId)).findFirst().orElse(null);
                if (lyrNode == null || (service = (GeoService)this.geoServiceRepository.findById(lyrNode.getServiceId()).orElse(null)) == null || (layer = (GeoServiceLayer)service.getLayers().stream().filter(l -> Objects.equals(l.getName(), lyrNode.getLayerName())).findFirst().orElse(null)) == null || !this.authorisationService.userAllowedToViewGeoServiceLayer(service, layer)) continue;
                allowedLayerIds.add(layerId);
            }
            if (allowedLayerIds.isEmpty()) {
                logger.trace("Skipping filterGroup {} because there are no allowed layers for this user", (Object)fg.getId());
                return false;
            }
            fg.setLayerIds(allowedLayerIds);
            return true;
        }).toList();
        return new ViewerResponse().kind(ViewerResponse.KindEnum.APP).name(application.getName()).title(application.getTitle()).styling(application.getStyling()).components(application.getComponents()).i18nSettings(Objects.requireNonNullElse(application.getSettings().getI18nSettings(), new AppI18nSettings().hideLanguageSwitcher(Boolean.valueOf(false)))).uiSettings(Objects.requireNonNullElse(application.getSettings().getUiSettings(), new AppUiSettings().hideLoginButton(Boolean.valueOf(false)))).projections(List.of(application.getCrs())).filterGroups(allowedFilterGroups);
    }
}

