/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.AppTreeNode;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="AppTreeLevelNode", description="Node for organizing app layer referencing nodes in a folder tree.")
public class AppTreeLevelNode
implements Serializable,
AppTreeNode {
    private static final long serialVersionUID = 1L;
    private String id;
    private String objectType;
    private String title;
    private String description;
    private Boolean root;
    @Valid
    private List<String> childrenIds = new ArrayList();

    public AppTreeLevelNode id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="A unique identifier across all tree nodes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppTreeLevelNode objectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    @Schema(name="objectType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="objectType")
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public AppTreeLevelNode title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", description="Display title of this tree node.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppTreeLevelNode description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description for this node entered by application admin.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AppTreeLevelNode root(Boolean root) {
        this.root = root;
        return this;
    }

    @NotNull
    @Schema(name="root", description="Only a single node in a tree will have this set to true.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="root")
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public AppTreeLevelNode childrenIds(List<String> childrenIds) {
        this.childrenIds = childrenIds;
        return this;
    }

    public AppTreeLevelNode addChildrenIdsItem(String childrenIdsItem) {
        if (this.childrenIds == null) {
            this.childrenIds = new ArrayList();
        }
        this.childrenIds.add(childrenIdsItem);
        return this;
    }

    @NotNull
    @Schema(name="childrenIds", description="Ordered list of ids of LayerTreeNodes that are children of this node.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="childrenIds")
    public List<String> getChildrenIds() {
        return this.childrenIds;
    }

    public void setChildrenIds(List<String> childrenIds) {
        this.childrenIds = childrenIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppTreeLevelNode appTreeLevelNode = (AppTreeLevelNode)o;
        return Objects.equals(this.id, appTreeLevelNode.id) && Objects.equals(this.objectType, appTreeLevelNode.objectType) && Objects.equals(this.title, appTreeLevelNode.title) && Objects.equals(this.description, appTreeLevelNode.description) && Objects.equals(this.root, appTreeLevelNode.root) && Objects.equals(this.childrenIds, appTreeLevelNode.childrenIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.objectType, this.title, this.description, this.root, this.childrenIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppTreeLevelNode {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    objectType: ").append(this.toIndentedString((Object)this.objectType)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    root: ").append(this.toIndentedString((Object)this.root)).append("\n");
        sb.append("    childrenIds: ").append(this.toIndentedString((Object)this.childrenIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

