/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.prometheus;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.tailormap.api.prometheus.TagNames;

@Component
public class PrometheusResultProcessor
implements TagNames {
    public Collection<Map<String, String>> processPrometheusResultsForApplications(JsonNode root) {
        HashMap<String, Map> groupedResults = new HashMap<String, Map>();
        for (JsonNode result : root.path("data").path("result")) {
            String appId = result.path("metric").path("appId").asText();
            String appName = result.path("metric").path("appName").asText();
            String type = result.path("metric").path("type").asText();
            String value = result.path("value").get(1).asText();
            groupedResults.computeIfAbsent(appId, k -> new HashMap()).put(type, value);
            ((Map)groupedResults.get(appId)).put("appName", appName);
            ((Map)groupedResults.get(appId)).put("appId", appId);
        }
        return groupedResults.values();
    }

    public Collection<Map<String, String>> processPrometheusResultsForApplicationLayers(JsonNode root) {
        HashMap<String, Map> groupedResults = new HashMap<String, Map>();
        for (JsonNode result : root.path("data").path("result")) {
            String appLayerId = result.path("metric").path("appLayerId").asText();
            String appId = result.path("metric").path("appId").asText();
            String appName = result.path("metric").path("appName").asText();
            String type = result.path("metric").path("type").asText();
            String value = result.path("value").get(1).asText();
            groupedResults.computeIfAbsent(appLayerId, k -> new HashMap()).put(type, value);
            ((Map)groupedResults.get(appLayerId)).put("appName", appName);
            ((Map)groupedResults.get(appLayerId)).put("appId", appId);
            ((Map)groupedResults.get(appLayerId)).put("appLayerId", appLayerId);
        }
        return groupedResults.values();
    }

    public ArrayNode processPrometheusResultsToJsonArray(JsonNode jsonResponse1, JsonNode jsonResponse2) throws IOException {
        JsonNode mergedResults = (JsonNode)new ObjectMapper().readerForUpdating((Object)jsonResponse1).readValue(jsonResponse2);
        Collection mergedResultsList = this.processPrometheusResultsForApplications(mergedResults);
        return (ArrayNode)new ObjectMapper().valueToTree((Object)mergedResultsList);
    }
}

