/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.SseEventBus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.tailormap.api.admin.model.SearchIndexSummary;
import org.tailormap.api.admin.model.ServerSentEvent;
import org.tailormap.api.admin.model.TaskProgressEvent;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.repository.FeatureTypeRepository;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.scheduling.Task;
import org.tailormap.api.scheduling.TaskType;
import org.tailormap.api.solr.SolrHelper;
import org.tailormap.api.solr.SolrService;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class IndexTask
extends QuartzJobBean
implements Task {
    public static final String INDEX_KEY = "indexId";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureTypeRepository featureTypeRepository;
    private final SearchIndexRepository searchIndexRepository;
    private final SolrService solrService;
    private final SseEventBus eventBus;
    private final ObjectMapper objectMapper;
    @Value(value="${tailormap-api.solr-batch-size:1000}")
    private int solrBatchSize;
    @Value(value="${tailormap-api.solr-geometry-validation-rule:repairBuffer0}")
    private String solrGeometryValidationRule;
    private long indexId;
    private String description;

    public IndexTask(@Autowired SearchIndexRepository searchIndexRepository, @Autowired FeatureTypeRepository featureTypeRepository, @Autowired FeatureSourceFactoryHelper featureSourceFactoryHelper, @Autowired SolrService solrService, @Autowired SseEventBus eventBus, @Autowired ObjectMapper objectMapper) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.solrService = solrService;
        this.featureTypeRepository = featureTypeRepository;
        this.searchIndexRepository = searchIndexRepository;
        this.eventBus = eventBus;
        this.objectMapper = objectMapper;
    }

    @Timed(value="indexTask", description="Time taken to execute index task")
    @Counted(value="indexTaskCount", description="Number of times index task executed")
    protected void executeInternal(@NonNull JobExecutionContext context) throws JobExecutionException {
        JobDataMap persistedJobData = context.getJobDetail().getJobDataMap();
        logger.info("Start Executing IndexTask {} for index {}, described with '{}'", new Object[]{context.getJobDetail().getKey(), this.getIndexId(), this.getDescription()});
        SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById((Object)this.getIndexId()).orElseThrow(() -> new JobExecutionException("Search index not found"));
        TMFeatureType indexingFT = (TMFeatureType)this.featureTypeRepository.findById((Object)searchIndex.getFeatureTypeId()).orElseThrow(() -> new JobExecutionException("Feature type for indexing not found"));
        try (SolrClient solrClient = this.solrService.getSolrClientForIndexing();
             SolrHelper solrHelper = new SolrHelper(solrClient).withBatchSize(this.solrBatchSize).withGeometryValidationRule(this.solrGeometryValidationRule);){
            persistedJobData.put("lastExecutionFinished", null);
            persistedJobData.put("lastResult", null);
            searchIndex = (SearchIndex)this.searchIndexRepository.save((Object)searchIndex.setStatus(SearchIndex.Status.INDEXING));
            searchIndex = solrHelper.addFeatureTypeIndex(searchIndex, indexingFT, this.featureSourceFactoryHelper, this.searchIndexRepository, arg_0 -> this.taskProgress(arg_0), UUID.fromString(context.getTrigger().getJobKey().getName()));
            searchIndex = (SearchIndex)this.searchIndexRepository.save((Object)searchIndex.setStatus(SearchIndex.Status.INDEXED));
            persistedJobData.put("executionCount", 1 + (Integer)context.getMergedJobDataMap().getOrDefault((Object)"executionCount", (Object)0));
            persistedJobData.put("lastExecutionFinished", (Object)Instant.now());
            persistedJobData.put("lastResult", "Index task executed successfully");
            context.setResult((Object)"Index task executed successfully");
        }
        catch (IOException | UnsupportedOperationException | SolrServerException | SolrException e) {
            logger.error("Error indexing", e);
            persistedJobData.put("lastExecutionFinished", null);
            persistedJobData.put("lastResult", "Index task failed with " + e.getMessage() + ". Check logs for details");
            this.searchIndexRepository.save((Object)searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(new SearchIndexSummary().errorMessage(e.getMessage())));
            context.setResult((Object)"Error indexing. Check logs for details.");
            throw new JobExecutionException("Error indexing", e);
        }
    }

    public void taskProgress(TaskProgressEvent event) {
        ServerSentEvent serverSentEvent = new ServerSentEvent().eventType(ServerSentEvent.EventTypeEnum.TASK_PROGRESS).details((Object)event);
        try {
            this.eventBus.handleEvent(SseEvent.of((String)"message", (Object)this.objectMapper.writeValueAsString((Object)serverSentEvent)));
        }
        catch (JsonProcessingException e) {
            logger.error("Error publishing indexing task progress event", (Throwable)e);
        }
    }

    public TaskType getType() {
        return TaskType.INDEX;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public void setIndexId(long indexId) {
        this.indexId = indexId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

