/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Objects;
import org.tailormap.api.persistence.json.TMAttributeType;

@Schema(name="ColumnMetadata", description="presentation metadata for a feature")
public class ColumnMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String alias = null;
    private TMAttributeType type;

    public ColumnMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Name of the attribute.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnMetadata alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(name="alias", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ColumnMetadata type(TMAttributeType type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TMAttributeType getType() {
        return this.type;
    }

    public void setType(TMAttributeType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata columnMetadata = (ColumnMetadata)o;
        return Objects.equals(this.name, columnMetadata.name) && Objects.equals(this.alias, columnMetadata.alias) && Objects.equals(this.type, columnMetadata.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.alias, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString((Object)this.alias)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

