package org.tailormap.api.admin.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Summary of a search index run. This is created/updated when the index is finished.
 */

@Schema(name = "SearchIndexSummary", description = "Summary of a search index run. This is created/updated when the index is finished.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class SearchIndexSummary implements Serializable {

  private static final long serialVersionUID = 1L;

  private Integer total = null;

  private Integer skippedCounter = null;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startedAt = null;

  private Double duration = null;

  private String errorMessage = null;

  public SearchIndexSummary total(Integer total) {
    this.total = total;
    return this;
  }

  /**
   * Total number of features counted for indexing. When 0 or null, the index was cleared.
   * @return total
   */
  
  @Schema(name = "total", description = "Total number of features counted for indexing. When 0 or null, the index was cleared.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("total")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public SearchIndexSummary skippedCounter(Integer skippedCounter) {
    this.skippedCounter = skippedCounter;
    return this;
  }

  /**
   * Number of features skipped during indexing.
   * @return skippedCounter
   */
  
  @Schema(name = "skippedCounter", description = "Number of features skipped during indexing.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("skippedCounter")
  public Integer getSkippedCounter() {
    return skippedCounter;
  }

  public void setSkippedCounter(Integer skippedCounter) {
    this.skippedCounter = skippedCounter;
  }

  public SearchIndexSummary startedAt(OffsetDateTime startedAt) {
    this.startedAt = startedAt;
    return this;
  }

  /**
   * Zoned date-time when the task started.
   * @return startedAt
   */
  @Valid 
  @Schema(name = "startedAt", example = "2024-12-13T11:30:40.863829185+01:00", description = "Zoned date-time when the task started.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startedAt")
  public OffsetDateTime getStartedAt() {
    return startedAt;
  }

  public void setStartedAt(OffsetDateTime startedAt) {
    this.startedAt = startedAt;
  }

  public SearchIndexSummary duration(Double duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Time taken to index the source in seconds.
   * @return duration
   */
  
  @Schema(name = "duration", description = "Time taken to index the source in seconds.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("duration")
  public Double getDuration() {
    return duration;
  }

  public void setDuration(Double duration) {
    this.duration = duration;
  }

  public SearchIndexSummary errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message if the task failed. Check the status field of the search index.
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", description = "Error message if the task failed. Check the status field of the search index.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchIndexSummary searchIndexSummary = (SearchIndexSummary) o;
    return Objects.equals(this.total, searchIndexSummary.total) &&
        Objects.equals(this.skippedCounter, searchIndexSummary.skippedCounter) &&
        Objects.equals(this.startedAt, searchIndexSummary.startedAt) &&
        Objects.equals(this.duration, searchIndexSummary.duration) &&
        Objects.equals(this.errorMessage, searchIndexSummary.errorMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, skippedCounter, startedAt, duration, errorMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchIndexSummary {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    skippedCounter: ").append(toIndentedString(skippedCounter)).append("\n");
    sb.append("    startedAt: ").append(toIndentedString(startedAt)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

