package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.HiddenLayerFunctionalityEnum;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * AppLayerSettings
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class AppLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Integer opacity = 100;

  private String attribution = null;

  private String description = null;

  private @Nullable Boolean editable = null;

  private Long formId = null;

  private Long searchIndexId = null;

  @Valid
  private List<String> hideAttributes = new ArrayList<>();

  @Valid
  private List<String> readOnlyAttributes = new ArrayList<>();

  private Double autoRefreshInSeconds = null;

  @Valid
  private Set<HiddenLayerFunctionalityEnum> hiddenFunctionality = new LinkedHashSet<>();

  public AppLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
   */
  
  @Schema(name = "title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public AppLayerSettings opacity(Integer opacity) {
    this.opacity = opacity;
    return this;
  }

  /**
   * Get opacity
   * @return opacity
   */
  
  @Schema(name = "opacity", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("opacity")
  public Integer getOpacity() {
    return opacity;
  }

  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }

  public AppLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
   */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public AppLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
   */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppLayerSettings editable(@Nullable Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Get editable
   * @return editable
   */
  
  @Schema(name = "editable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editable")
  public @Nullable Boolean getEditable() {
    return editable;
  }

  public void setEditable(@Nullable Boolean editable) {
    this.editable = editable;
  }

  public AppLayerSettings formId(Long formId) {
    this.formId = formId;
    return this;
  }

  /**
   * Get formId
   * @return formId
   */
  
  @Schema(name = "formId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("formId")
  public Long getFormId() {
    return formId;
  }

  public void setFormId(Long formId) {
    this.formId = formId;
  }

  public AppLayerSettings searchIndexId(Long searchIndexId) {
    this.searchIndexId = searchIndexId;
    return this;
  }

  /**
   * Get searchIndexId
   * @return searchIndexId
   */
  
  @Schema(name = "searchIndexId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("searchIndexId")
  public Long getSearchIndexId() {
    return searchIndexId;
  }

  public void setSearchIndexId(Long searchIndexId) {
    this.searchIndexId = searchIndexId;
  }

  public AppLayerSettings hideAttributes(List<String> hideAttributes) {
    this.hideAttributes = hideAttributes;
    return this;
  }

  public AppLayerSettings addHideAttributesItem(String hideAttributesItem) {
    if (this.hideAttributes == null) {
      this.hideAttributes = new ArrayList<>();
    }
    this.hideAttributes.add(hideAttributesItem);
    return this;
  }

  /**
   * List of attribute names that should be hidden (in addition to attributes already hidden by the feature type settings).
   * @return hideAttributes
   */
  
  @Schema(name = "hideAttributes", description = "List of attribute names that should be hidden (in addition to attributes already hidden by the feature type settings).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hideAttributes")
  public List<String> getHideAttributes() {
    return hideAttributes;
  }

  public void setHideAttributes(List<String> hideAttributes) {
    this.hideAttributes = hideAttributes;
  }

  public AppLayerSettings readOnlyAttributes(List<String> readOnlyAttributes) {
    this.readOnlyAttributes = readOnlyAttributes;
    return this;
  }

  public AppLayerSettings addReadOnlyAttributesItem(String readOnlyAttributesItem) {
    if (this.readOnlyAttributes == null) {
      this.readOnlyAttributes = new ArrayList<>();
    }
    this.readOnlyAttributes.add(readOnlyAttributesItem);
    return this;
  }

  /**
   * List of feature type attribute names that are not editable (in addition to read only attributes from the feature type settings).
   * @return readOnlyAttributes
   */
  
  @Schema(name = "readOnlyAttributes", description = "List of feature type attribute names that are not editable (in addition to read only attributes from the feature type settings).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("readOnlyAttributes")
  public List<String> getReadOnlyAttributes() {
    return readOnlyAttributes;
  }

  public void setReadOnlyAttributes(List<String> readOnlyAttributes) {
    this.readOnlyAttributes = readOnlyAttributes;
  }

  public AppLayerSettings autoRefreshInSeconds(Double autoRefreshInSeconds) {
    this.autoRefreshInSeconds = autoRefreshInSeconds;
    return this;
  }

  /**
   * Auto refresh layer in seconds
   * @return autoRefreshInSeconds
   */
  
  @Schema(name = "autoRefreshInSeconds", description = "Auto refresh layer in seconds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("autoRefreshInSeconds")
  public Double getAutoRefreshInSeconds() {
    return autoRefreshInSeconds;
  }

  public void setAutoRefreshInSeconds(Double autoRefreshInSeconds) {
    this.autoRefreshInSeconds = autoRefreshInSeconds;
  }

  public AppLayerSettings hiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
    this.hiddenFunctionality = hiddenFunctionality;
    return this;
  }

  public AppLayerSettings addHiddenFunctionalityItem(HiddenLayerFunctionalityEnum hiddenFunctionalityItem) {
    if (this.hiddenFunctionality == null) {
      this.hiddenFunctionality = new LinkedHashSet<>();
    }
    this.hiddenFunctionality.add(hiddenFunctionalityItem);
    return this;
  }

  /**
   * Functionality that should be hidden for a layer in the UI. The functionality is still available in the backend, so not a \"security\" setting.
   * @return hiddenFunctionality
   */
  @Valid 
  @Schema(name = "hiddenFunctionality", description = "Functionality that should be hidden for a layer in the UI. The functionality is still available in the backend, so not a \"security\" setting.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiddenFunctionality")
  public Set<HiddenLayerFunctionalityEnum> getHiddenFunctionality() {
    return hiddenFunctionality;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setHiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
    this.hiddenFunctionality = hiddenFunctionality;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppLayerSettings appLayerSettings = (AppLayerSettings) o;
    return Objects.equals(this.title, appLayerSettings.title) &&
        Objects.equals(this.opacity, appLayerSettings.opacity) &&
        Objects.equals(this.attribution, appLayerSettings.attribution) &&
        Objects.equals(this.description, appLayerSettings.description) &&
        Objects.equals(this.editable, appLayerSettings.editable) &&
        Objects.equals(this.formId, appLayerSettings.formId) &&
        Objects.equals(this.searchIndexId, appLayerSettings.searchIndexId) &&
        Objects.equals(this.hideAttributes, appLayerSettings.hideAttributes) &&
        Objects.equals(this.readOnlyAttributes, appLayerSettings.readOnlyAttributes) &&
        Objects.equals(this.autoRefreshInSeconds, appLayerSettings.autoRefreshInSeconds) &&
        Objects.equals(this.hiddenFunctionality, appLayerSettings.hiddenFunctionality);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, opacity, attribution, description, editable, formId, searchIndexId, hideAttributes, readOnlyAttributes, autoRefreshInSeconds, hiddenFunctionality);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    searchIndexId: ").append(toIndentedString(searchIndexId)).append("\n");
    sb.append("    hideAttributes: ").append(toIndentedString(hideAttributes)).append("\n");
    sb.append("    readOnlyAttributes: ").append(toIndentedString(readOnlyAttributes)).append("\n");
    sb.append("    autoRefreshInSeconds: ").append(toIndentedString(autoRefreshInSeconds)).append("\n");
    sb.append("    hiddenFunctionality: ").append(toIndentedString(hiddenFunctionality)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

