package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Bounds without the context of a coordinate reference system
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "Bounds", description = "Bounds without the context of a coordinate reference system")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
@jakarta.persistence.Embeddable
public class Bounds implements Serializable {

  private static final long serialVersionUID = 1L;

  private Double miny;

  private Double minx;

  private Double maxy;

  private Double maxx;

  public Bounds() {
    super();
  }

  public Bounds miny(Double miny) {
    this.miny = miny;
    return this;
  }

  /**
   * lower bottom
   * @return miny
   */
  @NotNull 
  @Schema(name = "miny", description = "lower bottom", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("miny")
  public Double getMiny() {
    return miny;
  }

  public void setMiny(Double miny) {
    this.miny = miny;
  }

  public Bounds minx(Double minx) {
    this.minx = minx;
    return this;
  }

  /**
   * lower left
   * @return minx
   */
  @NotNull 
  @Schema(name = "minx", description = "lower left", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("minx")
  public Double getMinx() {
    return minx;
  }

  public void setMinx(Double minx) {
    this.minx = minx;
  }

  public Bounds maxy(Double maxy) {
    this.maxy = maxy;
    return this;
  }

  /**
   * upper top
   * @return maxy
   */
  @NotNull 
  @Schema(name = "maxy", description = "upper top", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("maxy")
  public Double getMaxy() {
    return maxy;
  }

  public void setMaxy(Double maxy) {
    this.maxy = maxy;
  }

  public Bounds maxx(Double maxx) {
    this.maxx = maxx;
    return this;
  }

  /**
   * upper right
   * @return maxx
   */
  @NotNull 
  @Schema(name = "maxx", description = "upper right", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("maxx")
  public Double getMaxx() {
    return maxx;
  }

  public void setMaxx(Double maxx) {
    this.maxx = maxx;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Bounds bounds = (Bounds) o;
    return Objects.equals(this.miny, bounds.miny) &&
        Objects.equals(this.minx, bounds.minx) &&
        Objects.equals(this.maxy, bounds.maxy) &&
        Objects.equals(this.maxx, bounds.maxx);
  }

  @Override
  public int hashCode() {
    return Objects.hash(miny, minx, maxy, maxx);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Bounds {\n");
    sb.append("    miny: ").append(toIndentedString(miny)).append("\n");
    sb.append("    minx: ").append(toIndentedString(minx)).append("\n");
    sb.append("    maxy: ").append(toIndentedString(maxy)).append("\n");
    sb.append("    maxx: ").append(toIndentedString(maxx)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

