package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Configuration for a slider filter
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "SliderFilterConfiguration", description = "Configuration for a slider filter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class SliderFilterConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  private Double minimumValue;

  private Double maximumValue;

  private Double initialValue;

  private Double initialLowerValue;

  private Double initialUpperValue;

  /**
   * the mode of input for the filter
   */
  public enum InputModeEnum {
    SLIDER("SLIDER"),
    
    INPUT_FIELD("INPUT_FIELD"),
    
    SLIDER_AND_INPUT_FIELD("SLIDER_AND_INPUT_FIELD");

    private final String value;

    InputModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InputModeEnum fromValue(String value) {
      for (InputModeEnum b : InputModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private InputModeEnum inputMode = InputModeEnum.SLIDER;

  private Double stepSize;

  public SliderFilterConfiguration minimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
    return this;
  }

  /**
   * minimum value for the slider
   * @return minimumValue
   */
  
  @Schema(name = "minimumValue", description = "minimum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minimumValue")
  public Double getMinimumValue() {
    return minimumValue;
  }

  public void setMinimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
  }

  public SliderFilterConfiguration maximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
    return this;
  }

  /**
   * maximum value for the slider
   * @return maximumValue
   */
  
  @Schema(name = "maximumValue", description = "maximum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maximumValue")
  public Double getMaximumValue() {
    return maximumValue;
  }

  public void setMaximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
  }

  public SliderFilterConfiguration initialValue(Double initialValue) {
    this.initialValue = initialValue;
    return this;
  }

  /**
   * initial value for the slider
   * @return initialValue
   */
  
  @Schema(name = "initialValue", description = "initial value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialValue")
  public Double getInitialValue() {
    return initialValue;
  }

  public void setInitialValue(Double initialValue) {
    this.initialValue = initialValue;
  }

  public SliderFilterConfiguration initialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
    return this;
  }

  /**
   * initial lower value for a slider filter with between condition
   * @return initialLowerValue
   */
  
  @Schema(name = "initialLowerValue", description = "initial lower value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialLowerValue")
  public Double getInitialLowerValue() {
    return initialLowerValue;
  }

  public void setInitialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
  }

  public SliderFilterConfiguration initialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
    return this;
  }

  /**
   * initial upper value for a slider filter with between condition
   * @return initialUpperValue
   */
  
  @Schema(name = "initialUpperValue", description = "initial upper value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialUpperValue")
  public Double getInitialUpperValue() {
    return initialUpperValue;
  }

  public void setInitialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
  }

  public SliderFilterConfiguration inputMode(InputModeEnum inputMode) {
    this.inputMode = inputMode;
    return this;
  }

  /**
   * the mode of input for the filter
   * @return inputMode
   */
  
  @Schema(name = "inputMode", description = "the mode of input for the filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputMode")
  public InputModeEnum getInputMode() {
    return inputMode;
  }

  public void setInputMode(InputModeEnum inputMode) {
    this.inputMode = inputMode;
  }

  public SliderFilterConfiguration stepSize(Double stepSize) {
    this.stepSize = stepSize;
    return this;
  }

  /**
   * the step size for the slider
   * @return stepSize
   */
  
  @Schema(name = "stepSize", description = "the step size for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("stepSize")
  public Double getStepSize() {
    return stepSize;
  }

  public void setStepSize(Double stepSize) {
    this.stepSize = stepSize;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SliderFilterConfiguration sliderFilterConfiguration = (SliderFilterConfiguration) o;
    return Objects.equals(this.minimumValue, sliderFilterConfiguration.minimumValue) &&
        Objects.equals(this.maximumValue, sliderFilterConfiguration.maximumValue) &&
        Objects.equals(this.initialValue, sliderFilterConfiguration.initialValue) &&
        Objects.equals(this.initialLowerValue, sliderFilterConfiguration.initialLowerValue) &&
        Objects.equals(this.initialUpperValue, sliderFilterConfiguration.initialUpperValue) &&
        Objects.equals(this.inputMode, sliderFilterConfiguration.inputMode) &&
        Objects.equals(this.stepSize, sliderFilterConfiguration.stepSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumValue, maximumValue, initialValue, initialLowerValue, initialUpperValue, inputMode, stepSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SliderFilterConfiguration {\n");
    sb.append("    minimumValue: ").append(toIndentedString(minimumValue)).append("\n");
    sb.append("    maximumValue: ").append(toIndentedString(maximumValue)).append("\n");
    sb.append("    initialValue: ").append(toIndentedString(initialValue)).append("\n");
    sb.append("    initialLowerValue: ").append(toIndentedString(initialLowerValue)).append("\n");
    sb.append("    initialUpperValue: ").append(toIndentedString(initialUpperValue)).append("\n");
    sb.append("    inputMode: ").append(toIndentedString(inputMode)).append("\n");
    sb.append("    stepSize: ").append(toIndentedString(stepSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

