package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.Bounds;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TMFeatureTypeInfo
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class TMFeatureTypeInfo implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private Set<String> keywords = new LinkedHashSet<>();

  private String description;

  private URI publisher;

  private URI schema;

  private URI source;

  private Bounds bounds;

  private String crs;

  private Bounds wgs84BoundingBox;

  private String defaultSrs;

  @Valid
  private Set<String> otherSrs = new LinkedHashSet<>();

  @Valid
  private Set<String> outputFormats = new LinkedHashSet<>();

  private String abstractText;

  public TMFeatureTypeInfo keywords(Set<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  public TMFeatureTypeInfo addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new LinkedHashSet<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

  /**
   * Get keywords
   * @return keywords
   */
  
  @Schema(name = "keywords", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("keywords")
  public Set<String> getKeywords() {
    return keywords;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setKeywords(Set<String> keywords) {
    this.keywords = keywords;
  }

  public TMFeatureTypeInfo description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TMFeatureTypeInfo publisher(URI publisher) {
    this.publisher = publisher;
    return this;
  }

  /**
   * Get publisher
   * @return publisher
   */
  @Valid 
  @Schema(name = "publisher", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("publisher")
  public URI getPublisher() {
    return publisher;
  }

  public void setPublisher(URI publisher) {
    this.publisher = publisher;
  }

  public TMFeatureTypeInfo schema(URI schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Get schema
   * @return schema
   */
  @Valid 
  @Schema(name = "schema", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("schema")
  public URI getSchema() {
    return schema;
  }

  public void setSchema(URI schema) {
    this.schema = schema;
  }

  public TMFeatureTypeInfo source(URI source) {
    this.source = source;
    return this;
  }

  /**
   * Get source
   * @return source
   */
  @Valid 
  @Schema(name = "source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("source")
  public URI getSource() {
    return source;
  }

  public void setSource(URI source) {
    this.source = source;
  }

  public TMFeatureTypeInfo bounds(Bounds bounds) {
    this.bounds = bounds;
    return this;
  }

  /**
   * Get bounds
   * @return bounds
   */
  @Valid 
  @Schema(name = "bounds", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("bounds")
  public Bounds getBounds() {
    return bounds;
  }

  public void setBounds(Bounds bounds) {
    this.bounds = bounds;
  }

  public TMFeatureTypeInfo crs(String crs) {
    this.crs = crs;
    return this;
  }

  /**
   * Get crs
   * @return crs
   */
  
  @Schema(name = "crs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("crs")
  public String getCrs() {
    return crs;
  }

  public void setCrs(String crs) {
    this.crs = crs;
  }

  public TMFeatureTypeInfo wgs84BoundingBox(Bounds wgs84BoundingBox) {
    this.wgs84BoundingBox = wgs84BoundingBox;
    return this;
  }

  /**
   * Get wgs84BoundingBox
   * @return wgs84BoundingBox
   */
  @Valid 
  @Schema(name = "wgs84BoundingBox", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("wgs84BoundingBox")
  public Bounds getWgs84BoundingBox() {
    return wgs84BoundingBox;
  }

  public void setWgs84BoundingBox(Bounds wgs84BoundingBox) {
    this.wgs84BoundingBox = wgs84BoundingBox;
  }

  public TMFeatureTypeInfo defaultSrs(String defaultSrs) {
    this.defaultSrs = defaultSrs;
    return this;
  }

  /**
   * Get defaultSrs
   * @return defaultSrs
   */
  
  @Schema(name = "defaultSrs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultSrs")
  public String getDefaultSrs() {
    return defaultSrs;
  }

  public void setDefaultSrs(String defaultSrs) {
    this.defaultSrs = defaultSrs;
  }

  public TMFeatureTypeInfo otherSrs(Set<String> otherSrs) {
    this.otherSrs = otherSrs;
    return this;
  }

  public TMFeatureTypeInfo addOtherSrsItem(String otherSrsItem) {
    if (this.otherSrs == null) {
      this.otherSrs = new LinkedHashSet<>();
    }
    this.otherSrs.add(otherSrsItem);
    return this;
  }

  /**
   * Get otherSrs
   * @return otherSrs
   */
  
  @Schema(name = "otherSrs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("otherSrs")
  public Set<String> getOtherSrs() {
    return otherSrs;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setOtherSrs(Set<String> otherSrs) {
    this.otherSrs = otherSrs;
  }

  public TMFeatureTypeInfo outputFormats(Set<String> outputFormats) {
    this.outputFormats = outputFormats;
    return this;
  }

  public TMFeatureTypeInfo addOutputFormatsItem(String outputFormatsItem) {
    if (this.outputFormats == null) {
      this.outputFormats = new LinkedHashSet<>();
    }
    this.outputFormats.add(outputFormatsItem);
    return this;
  }

  /**
   * Get outputFormats
   * @return outputFormats
   */
  
  @Schema(name = "outputFormats", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("outputFormats")
  public Set<String> getOutputFormats() {
    return outputFormats;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setOutputFormats(Set<String> outputFormats) {
    this.outputFormats = outputFormats;
  }

  public TMFeatureTypeInfo abstractText(String abstractText) {
    this.abstractText = abstractText;
    return this;
  }

  /**
   * Get abstractText
   * @return abstractText
   */
  
  @Schema(name = "abstractText", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("abstractText")
  public String getAbstractText() {
    return abstractText;
  }

  public void setAbstractText(String abstractText) {
    this.abstractText = abstractText;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMFeatureTypeInfo tmFeatureTypeInfo = (TMFeatureTypeInfo) o;
    return Objects.equals(this.keywords, tmFeatureTypeInfo.keywords) &&
        Objects.equals(this.description, tmFeatureTypeInfo.description) &&
        Objects.equals(this.publisher, tmFeatureTypeInfo.publisher) &&
        Objects.equals(this.schema, tmFeatureTypeInfo.schema) &&
        Objects.equals(this.source, tmFeatureTypeInfo.source) &&
        Objects.equals(this.bounds, tmFeatureTypeInfo.bounds) &&
        Objects.equals(this.crs, tmFeatureTypeInfo.crs) &&
        Objects.equals(this.wgs84BoundingBox, tmFeatureTypeInfo.wgs84BoundingBox) &&
        Objects.equals(this.defaultSrs, tmFeatureTypeInfo.defaultSrs) &&
        Objects.equals(this.otherSrs, tmFeatureTypeInfo.otherSrs) &&
        Objects.equals(this.outputFormats, tmFeatureTypeInfo.outputFormats) &&
        Objects.equals(this.abstractText, tmFeatureTypeInfo.abstractText);
  }

  @Override
  public int hashCode() {
    return Objects.hash(keywords, description, publisher, schema, source, bounds, crs, wgs84BoundingBox, defaultSrs, otherSrs, outputFormats, abstractText);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMFeatureTypeInfo {\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    publisher: ").append(toIndentedString(publisher)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    wgs84BoundingBox: ").append(toIndentedString(wgs84BoundingBox)).append("\n");
    sb.append("    defaultSrs: ").append(toIndentedString(defaultSrs)).append("\n");
    sb.append("    otherSrs: ").append(toIndentedString(otherSrs)).append("\n");
    sb.append("    outputFormats: ").append(toIndentedString(outputFormats)).append("\n");
    sb.append("    abstractText: ").append(toIndentedString(abstractText)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

