package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model for a menu item for pages
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "ViewerMenuItem", description = "model for a menu item for pages")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class ViewerMenuItem implements Serializable {

  private static final long serialVersionUID = 1L;

  private String label;

  private String pageUrl = null;

  private String url = null;

  private Boolean openInNewWindow = null;

  public ViewerMenuItem label(String label) {
    this.label = label;
    return this;
  }

  /**
   * menu item label
   * @return label
   */
  
  @Schema(name = "label", description = "menu item label", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public ViewerMenuItem pageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
    return this;
  }

  /**
   * link to another page
   * @return pageUrl
   */
  
  @Schema(name = "pageUrl", description = "link to another page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageUrl")
  public String getPageUrl() {
    return pageUrl;
  }

  public void setPageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
  }

  public ViewerMenuItem url(String url) {
    this.url = url;
    return this;
  }

  /**
   * link to an other domain / website
   * @return url
   */
  
  @Schema(name = "url", description = "link to an other domain / website", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public ViewerMenuItem openInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
    return this;
  }

  /**
   * indicates whether the link should be opened in a new window
   * @return openInNewWindow
   */
  
  @Schema(name = "openInNewWindow", description = "indicates whether the link should be opened in a new window", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("openInNewWindow")
  public Boolean getOpenInNewWindow() {
    return openInNewWindow;
  }

  public void setOpenInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViewerMenuItem viewerMenuItem = (ViewerMenuItem) o;
    return Objects.equals(this.label, viewerMenuItem.label) &&
        Objects.equals(this.pageUrl, viewerMenuItem.pageUrl) &&
        Objects.equals(this.url, viewerMenuItem.url) &&
        Objects.equals(this.openInNewWindow, viewerMenuItem.openInNewWindow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(label, pageUrl, url, openInNewWindow);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViewerMenuItem {\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    pageUrl: ").append(toIndentedString(pageUrl)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    openInNewWindow: ").append(toIndentedString(openInNewWindow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

