package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.FormField;
import org.tailormap.api.persistence.json.FormOptions;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * LayerDetailsForm
 */

@JsonTypeName("LayerDetails_form")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class LayerDetailsForm implements Serializable {

  private static final long serialVersionUID = 1L;

  private FormOptions options;

  @Valid
  private List<@Valid FormField> fields = new ArrayList<>();

  public LayerDetailsForm options(FormOptions options) {
    this.options = options;
    return this;
  }

  /**
   * Get options
   * @return options
   */
  @Valid 
  @Schema(name = "options", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("options")
  public FormOptions getOptions() {
    return options;
  }

  public void setOptions(FormOptions options) {
    this.options = options;
  }

  public LayerDetailsForm fields(List<@Valid FormField> fields) {
    this.fields = fields;
    return this;
  }

  public LayerDetailsForm addFieldsItem(FormField fieldsItem) {
    if (this.fields == null) {
      this.fields = new ArrayList<>();
    }
    this.fields.add(fieldsItem);
    return this;
  }

  /**
   * Get fields
   * @return fields
   */
  @Valid 
  @Schema(name = "fields", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fields")
  public List<@Valid FormField> getFields() {
    return fields;
  }

  public void setFields(List<@Valid FormField> fields) {
    this.fields = fields;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LayerDetailsForm layerDetailsForm = (LayerDetailsForm) o;
    return Objects.equals(this.options, layerDetailsForm.options) &&
        Objects.equals(this.fields, layerDetailsForm.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(options, fields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LayerDetailsForm {\n");
    sb.append("    options: ").append(toIndentedString(options)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

