/*
 * Decompiled with CFR 0.152.
 */
package db.migration;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.codec.digest.DigestUtils;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V18__UploadHash
extends BaseJavaMigration {
    public void migrate(Context context) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)new SingleConnectionDataSource(context.getConnection(), true));
        jdbcTemplate.execute("alter table upload add column hash char(40) null");
        List rows = jdbcTemplate.queryForList("select id, content from upload");
        for (Map row : rows) {
            UUID id = (UUID)row.get("id");
            byte[] content = (byte[])row.get("content");
            if (content == null) continue;
            String hash = DigestUtils.sha1Hex((byte[])content);
            jdbcTemplate.update("update upload set hash = ? where id = ?", new Object[]{hash, id});
        }
    }
}

