/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="DatePickerFilterConfiguration", description="Configuration for a date filter")
public class DatePickerFilterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialLowerDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialUpperDate;

    public DatePickerFilterConfiguration initialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
        return this;
    }

    @Valid
    @Schema(name="initialDate", description="initial value for the date filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialDate")
    public OffsetDateTime getInitialDate() {
        return this.initialDate;
    }

    public void setInitialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
    }

    public DatePickerFilterConfiguration initialLowerDate(OffsetDateTime initialLowerDate) {
        this.initialLowerDate = initialLowerDate;
        return this;
    }

    @Valid
    @Schema(name="initialLowerDate", description="initial lower value for a date filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerDate")
    public OffsetDateTime getInitialLowerDate() {
        return this.initialLowerDate;
    }

    public void setInitialLowerDate(OffsetDateTime initialLowerDate) {
        this.initialLowerDate = initialLowerDate;
    }

    public DatePickerFilterConfiguration initialUpperDate(OffsetDateTime initialUpperDate) {
        this.initialUpperDate = initialUpperDate;
        return this;
    }

    @Valid
    @Schema(name="initialUpperDate", description="initial upper value for a date filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperDate")
    public OffsetDateTime getInitialUpperDate() {
        return this.initialUpperDate;
    }

    public void setInitialUpperDate(OffsetDateTime initialUpperDate) {
        this.initialUpperDate = initialUpperDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatePickerFilterConfiguration datePickerFilterConfiguration = (DatePickerFilterConfiguration)o;
        return Objects.equals(this.initialDate, datePickerFilterConfiguration.initialDate) && Objects.equals(this.initialLowerDate, datePickerFilterConfiguration.initialLowerDate) && Objects.equals(this.initialUpperDate, datePickerFilterConfiguration.initialUpperDate);
    }

    public int hashCode() {
        return Objects.hash(this.initialDate, this.initialLowerDate, this.initialUpperDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatePickerFilterConfiguration {\n");
        sb.append("    initialDate: ").append(this.toIndentedString((Object)this.initialDate)).append("\n");
        sb.append("    initialLowerDate: ").append(this.toIndentedString((Object)this.initialLowerDate)).append("\n");
        sb.append("    initialUpperDate: ").append(this.toIndentedString((Object)this.initialUpperDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

