/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="MenuItem", description="model for a menu items")
public class MenuItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String label;
    private String pageUrl = null;
    private String url = null;
    private Boolean openInNewWindow = null;
    private Long pageId;
    private Long exclusiveOnPageId;

    public MenuItem label(String label) {
        this.label = label;
        return this;
    }

    @Schema(name="label", description="menu item label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public MenuItem pageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    @Schema(name="pageUrl", description="link to another page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageUrl")
    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public MenuItem url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="link to an other domain / website", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MenuItem openInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
        return this;
    }

    @Schema(name="openInNewWindow", description="indicates whether the link should be opened in a new window", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="openInNewWindow")
    public Boolean getOpenInNewWindow() {
        return this.openInNewWindow;
    }

    public void setOpenInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public MenuItem pageId(Long pageId) {
        this.pageId = pageId;
        return this;
    }

    @Schema(name="pageId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageId")
    public Long getPageId() {
        return this.pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public MenuItem exclusiveOnPageId(Long exclusiveOnPageId) {
        this.exclusiveOnPageId = exclusiveOnPageId;
        return this;
    }

    @Schema(name="exclusiveOnPageId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="exclusiveOnPageId")
    public Long getExclusiveOnPageId() {
        return this.exclusiveOnPageId;
    }

    public void setExclusiveOnPageId(Long exclusiveOnPageId) {
        this.exclusiveOnPageId = exclusiveOnPageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuItem menuItem = (MenuItem)o;
        return Objects.equals(this.label, menuItem.label) && Objects.equals(this.pageUrl, menuItem.pageUrl) && Objects.equals(this.url, menuItem.url) && Objects.equals(this.openInNewWindow, menuItem.openInNewWindow) && Objects.equals(this.pageId, menuItem.pageId) && Objects.equals(this.exclusiveOnPageId, menuItem.exclusiveOnPageId);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.pageUrl, this.url, this.openInNewWindow, this.pageId, this.exclusiveOnPageId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MenuItem {\n");
        sb.append("    label: ").append(this.toIndentedString((Object)this.label)).append("\n");
        sb.append("    pageUrl: ").append(this.toIndentedString((Object)this.pageUrl)).append("\n");
        sb.append("    url: ").append(this.toIndentedString((Object)this.url)).append("\n");
        sb.append("    openInNewWindow: ").append(this.toIndentedString((Object)this.openInNewWindow)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString((Object)this.pageId)).append("\n");
        sb.append("    exclusiveOnPageId: ").append(this.toIndentedString((Object)this.exclusiveOnPageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

