/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.tailormap.api.persistence.OIDCConfiguration;
import org.tailormap.api.repository.OIDCConfigurationRepository;
import org.tailormap.api.security.OIDCRepository;

public class OIDCRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OIDCConfigurationRepository oidcConfigurationRepository;
    @Value(value="${tailormap-api.oidc.name:#{null}}")
    private String oidcName;
    @Value(value="${tailormap-api.oidc.issuer-uri:#{null}}")
    private String oidcIssuerUri;
    @Value(value="${tailormap-api.oidc.client-id:#{null}}")
    private String oidcClientId;
    @Value(value="${tailormap-api.oidc.client-secret:#{null}}")
    private String oidcClientSecret;
    @Value(value="${tailormap-api.oidc.user-name-attribute:#{null}}")
    private String oidcUserNameAttribute;
    @Value(value="${tailormap-api.oidc.show-for-viewer:false}")
    private boolean oidcShowForViewer;
    private final Map<String, ClientRegistration> registrations;

    public OIDCRepository(OIDCConfigurationRepository repository) {
        this.oidcConfigurationRepository = repository;
        this.registrations = new HashMap();
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        return (ClientRegistration)this.registrations.get(registrationId);
    }

    @Override
    @Nonnull
    public Iterator<ClientRegistration> iterator() {
        return this.registrations.values().iterator();
    }

    public OIDCRegistrationMetadata getMetadataForRegistrationId(String id) {
        OIDCRegistrationMetadata metadata = new OIDCRegistrationMetadata();
        metadata.showForViewer = "static".equals(id) ? this.oidcShowForViewer : true;
        return metadata;
    }

    @PostConstruct
    public void synchronize() {
        HashMap<String, ClientRegistration> newMap = new HashMap<String, ClientRegistration>();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        for (OIDCConfiguration configuration : this.oidcConfigurationRepository.findAll()) {
            String id = String.format("%d", configuration.getId());
            try {
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(configuration.getIssuerUrl() + "/.well-known/openid-configuration"));
                HttpResponse<String> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)response.body());
                newMap.put(id, ClientRegistration.withRegistrationId((String)id).clientId(configuration.getClientId()).clientSecret(configuration.getClientSecret()).clientName(configuration.getName()).scope(new String[]{"openid"}).issuerUri(metadata.getIssuer().toString()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationUri(metadata.getAuthorizationEndpointURI().toASCIIString()).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString()).providerConfigurationMetadata((Map)metadata.toJSONObject()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).userNameAttributeName(configuration.getUserNameAttribute()).redirectUri("{baseUrl}/api/oauth2/callback").build());
                if (configuration.getStatus() == null) continue;
                configuration.setStatus(null);
                this.oidcConfigurationRepository.save((Object)configuration);
            }
            catch (Exception e) {
                logger.error("Failed to create OIDC client registration for ID {}", (Object)id, (Object)e);
                configuration.setStatus(e.toString());
                this.oidcConfigurationRepository.save((Object)configuration);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.oidcName) && StringUtils.isNotBlank((CharSequence)this.oidcIssuerUri) && StringUtils.isNotBlank((CharSequence)this.oidcClientId)) {
            try {
                if (!this.oidcIssuerUri.endsWith("/.well-known/openid-configuration")) {
                    this.oidcIssuerUri = this.oidcIssuerUri + "/.well-known/openid-configuration";
                }
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(this.oidcIssuerUri));
                HttpResponse<String> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofString());
                OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)response.body());
                String id = "static";
                newMap.put(id, ClientRegistration.withRegistrationId((String)id).clientId(this.oidcClientId).clientSecret(this.oidcClientSecret).clientName(this.oidcName).scope(new String[]{"openid"}).issuerUri(metadata.getIssuer().toString()).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).authorizationUri(metadata.getAuthorizationEndpointURI().toASCIIString()).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString()).providerConfigurationMetadata((Map)metadata.toJSONObject()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).userNameAttributeName(this.oidcUserNameAttribute).redirectUri("{baseUrl}/api/oauth2/callback").build());
            }
            catch (Exception e) {
                logger.error("Failed to create static OIDC client registration", (Throwable)e);
            }
        }
        this.registrations.clear();
        this.registrations.putAll(newMap);
    }
}

