package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.TMAttributeType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Attribute
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class Attribute implements Serializable {

  private static final long serialVersionUID = 1L;

  private String name;

  private String alias;

  private TMAttributeType type;

  private Boolean editable;

  private String defaultValue = null;

  private Boolean nullable;

  public Attribute() {
    super();
  }

  public Attribute name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name of the attribute.
   * @return name
   */
  @NotNull 
  @Schema(name = "name", description = "Name of the attribute.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Attribute alias(String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * Alias of the attribute.
   * @return alias
   */
  
  @Schema(name = "alias", description = "Alias of the attribute.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias")
  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public Attribute type(TMAttributeType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TMAttributeType getType() {
    return type;
  }

  public void setType(TMAttributeType type) {
    this.type = type;
  }

  public Attribute editable(Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Whether the attribute can be edited.
   * @return editable
   */
  
  @Schema(name = "editable", description = "Whether the attribute can be edited.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editable")
  public Boolean getEditable() {
    return editable;
  }

  public void setEditable(Boolean editable) {
    this.editable = editable;
  }

  public Attribute defaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Default value for this attribute. The value may need to be coerced to the correct type.
   * @return defaultValue
   */
  
  @Schema(name = "defaultValue", description = "Default value for this attribute. The value may need to be coerced to the correct type.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultValue")
  public String getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
  }

  public Attribute nullable(Boolean nullable) {
    this.nullable = nullable;
    return this;
  }

  /**
   * Whether the attribute can be null.
   * @return nullable
   */
  
  @Schema(name = "nullable", description = "Whether the attribute can be null.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("nullable")
  public Boolean getNullable() {
    return nullable;
  }

  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Attribute attribute = (Attribute) o;
    return Objects.equals(this.name, attribute.name) &&
        Objects.equals(this.alias, attribute.alias) &&
        Objects.equals(this.type, attribute.type) &&
        Objects.equals(this.editable, attribute.editable) &&
        Objects.equals(this.defaultValue, attribute.defaultValue) &&
        Objects.equals(this.nullable, attribute.nullable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, alias, type, editable, defaultValue, nullable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Attribute {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    nullable: ").append(toIndentedString(nullable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

