package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.FilterEditConfiguration;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A filter for an attribute. The filter can be used to filter the features of a layer, based on attribute value
 */

@Schema(name = "Filter", description = "A filter for an attribute. The filter can be used to filter the features of a layer, based on attribute value")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class Filter implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  /**
   * type of the filter
   */
  public enum TypeEnum {
    ATTRIBUTE("ATTRIBUTE");

    private final String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private TypeEnum type;

  /**
   * Gets or Sets condition
   */
  public enum ConditionEnum {
    UNIQUE_VALUES("UNIQUE_VALUES"),
    
    EQUAL("="),
    
    NOT_EQUAL("<>"),
    
    GREATER_THAN(">"),
    
    LESS_THAN("<"),
    
    GREATER_THAN_OR_EQUAL_TO(">="),
    
    LESS_THAN_OR_EQUAL_TO("<="),
    
    u("><"),
    
    EQUALS("EQUALS"),
    
    LIKE("LIKE"),
    
    STARTS_WITH("STARTS_WITH"),
    
    ENDS_WITH("ENDS_WITH"),
    
    ON("ON"),
    
    AFTER("AFTER"),
    
    BEFORE("BEFORE"),
    
    BETWEEN("BETWEEN"),
    
    TRUE("TRUE"),
    
    FALSE("FALSE"),
    
    NULL("NULL");

    private final String value;

    ConditionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ConditionEnum fromValue(String value) {
      for (ConditionEnum b : ConditionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ConditionEnum condition;

  private Boolean invertCondition = false;

  private String attribute;

  /**
   * type of the attribute
   */
  public enum AttributeTypeEnum {
    DATE("date"),
    
    TIMESTAMP("timestamp"),
    
    STRING("string"),
    
    DOUBLE("double"),
    
    NUMBER("number"),
    
    INTEGER("integer"),
    
    BOOLEAN("boolean");

    private final String value;

    AttributeTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AttributeTypeEnum fromValue(String value) {
      for (AttributeTypeEnum b : AttributeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private AttributeTypeEnum attributeType;

  @Valid
  private List<String> value = new ArrayList<>();

  private Boolean caseSensitive = false;

  private FilterEditConfiguration editConfiguration;

  public Filter id(String id) {
    this.id = id;
    return this;
  }

  /**
   * id of the filter
   * @return id
   */
  
  @Schema(name = "id", description = "id of the filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Filter type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * type of the filter
   * @return type
   */
  
  @Schema(name = "type", description = "type of the filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public Filter condition(ConditionEnum condition) {
    this.condition = condition;
    return this;
  }

  /**
   * Get condition
   * @return condition
   */
  
  @Schema(name = "condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("condition")
  public ConditionEnum getCondition() {
    return condition;
  }

  public void setCondition(ConditionEnum condition) {
    this.condition = condition;
  }

  public Filter invertCondition(Boolean invertCondition) {
    this.invertCondition = invertCondition;
    return this;
  }

  /**
   * when true the condition is to be inverted
   * @return invertCondition
   */
  
  @Schema(name = "invertCondition", description = "when true the condition is to be inverted", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("invertCondition")
  public Boolean getInvertCondition() {
    return invertCondition;
  }

  public void setInvertCondition(Boolean invertCondition) {
    this.invertCondition = invertCondition;
  }

  public Filter attribute(String attribute) {
    this.attribute = attribute;
    return this;
  }

  /**
   * name of the attribute
   * @return attribute
   */
  
  @Schema(name = "attribute", description = "name of the attribute", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribute")
  public String getAttribute() {
    return attribute;
  }

  public void setAttribute(String attribute) {
    this.attribute = attribute;
  }

  public Filter attributeType(AttributeTypeEnum attributeType) {
    this.attributeType = attributeType;
    return this;
  }

  /**
   * type of the attribute
   * @return attributeType
   */
  
  @Schema(name = "attributeType", description = "type of the attribute", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributeType")
  public AttributeTypeEnum getAttributeType() {
    return attributeType;
  }

  public void setAttributeType(AttributeTypeEnum attributeType) {
    this.attributeType = attributeType;
  }

  public Filter value(List<String> value) {
    this.value = value;
    return this;
  }

  public Filter addValueItem(String valueItem) {
    if (this.value == null) {
      this.value = new ArrayList<>();
    }
    this.value.add(valueItem);
    return this;
  }

  /**
   * value of the filter
   * @return value
   */
  
  @Schema(name = "value", description = "value of the filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value")
  public List<String> getValue() {
    return value;
  }

  public void setValue(List<String> value) {
    this.value = value;
  }

  public Filter caseSensitive(Boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
    return this;
  }

  /**
   * true when the filter is case sensitive
   * @return caseSensitive
   */
  
  @Schema(name = "caseSensitive", description = "true when the filter is case sensitive", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("caseSensitive")
  public Boolean getCaseSensitive() {
    return caseSensitive;
  }

  public void setCaseSensitive(Boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
  }

  public Filter editConfiguration(FilterEditConfiguration editConfiguration) {
    this.editConfiguration = editConfiguration;
    return this;
  }

  /**
   * Get editConfiguration
   * @return editConfiguration
   */
  @Valid 
  @Schema(name = "editConfiguration", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editConfiguration")
  public FilterEditConfiguration getEditConfiguration() {
    return editConfiguration;
  }

  public void setEditConfiguration(FilterEditConfiguration editConfiguration) {
    this.editConfiguration = editConfiguration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Filter filter = (Filter) o;
    return Objects.equals(this.id, filter.id) &&
        Objects.equals(this.type, filter.type) &&
        Objects.equals(this.condition, filter.condition) &&
        Objects.equals(this.invertCondition, filter.invertCondition) &&
        Objects.equals(this.attribute, filter.attribute) &&
        Objects.equals(this.attributeType, filter.attributeType) &&
        Objects.equals(this.value, filter.value) &&
        Objects.equals(this.caseSensitive, filter.caseSensitive) &&
        Objects.equals(this.editConfiguration, filter.editConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, condition, invertCondition, attribute, attributeType, value, caseSensitive, editConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Filter {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("    invertCondition: ").append(toIndentedString(invertCondition)).append("\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
    sb.append("    attributeType: ").append(toIndentedString(attributeType)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    caseSensitive: ").append(toIndentedString(caseSensitive)).append("\n");
    sb.append("    editConfiguration: ").append(toIndentedString(editConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

