package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.ViewerMenuItem;
import org.tailormap.api.viewer.model.ViewerPageTile;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * PageResponse
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class PageResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;

  private String type = null;

  private String name = null;

  private String title = null;

  private String content = null;

  private String className = null;

  @Valid
  private List<@Valid ViewerPageTile> tiles = new ArrayList<>();

  @Valid
  private List<@Valid ViewerMenuItem> menu = new ArrayList<>();

  public PageResponse id(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  
  @Schema(name = "id", accessMode = Schema.AccessMode.READ_ONLY, requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public PageResponse type(String type) {
    this.type = type;
    return this;
  }

  /**
   * define the type of the page which can be used to switch between layouts for example
   * @return type
   */
  
  @Schema(name = "type", description = "define the type of the page which can be used to switch between layouts for example", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public PageResponse name(String name) {
    this.name = name;
    return this;
  }

  /**
   * name of the page which will be used for the url
   * @return name
   */
  
  @Schema(name = "name", description = "name of the page which will be used for the url", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public PageResponse title(String title) {
    this.title = title;
    return this;
  }

  /**
   * page title
   * @return title
   */
  
  @Schema(name = "title", description = "page title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public PageResponse content(String content) {
    this.content = content;
    return this;
  }

  /**
   * Get content
   * @return content
   */
  
  @Schema(name = "content", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public PageResponse className(String className) {
    this.className = className;
    return this;
  }

  /**
   * page body content
   * @return className
   */
  
  @Schema(name = "className", description = "page body content", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("className")
  public String getClassName() {
    return className;
  }

  public void setClassName(String className) {
    this.className = className;
  }

  public PageResponse tiles(List<@Valid ViewerPageTile> tiles) {
    this.tiles = tiles;
    return this;
  }

  public PageResponse addTilesItem(ViewerPageTile tilesItem) {
    if (this.tiles == null) {
      this.tiles = new ArrayList<>();
    }
    this.tiles.add(tilesItem);
    return this;
  }

  /**
   * list of tiles, tiles are used to link to applications or other pages
   * @return tiles
   */
  @Valid @Size(min = 0) 
  @Schema(name = "tiles", description = "list of tiles, tiles are used to link to applications or other pages", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tiles")
  public List<@Valid ViewerPageTile> getTiles() {
    return tiles;
  }

  public void setTiles(List<@Valid ViewerPageTile> tiles) {
    this.tiles = tiles;
  }

  public PageResponse menu(List<@Valid ViewerMenuItem> menu) {
    this.menu = menu;
    return this;
  }

  public PageResponse addMenuItem(ViewerMenuItem menuItem) {
    if (this.menu == null) {
      this.menu = new ArrayList<>();
    }
    this.menu.add(menuItem);
    return this;
  }

  /**
   * list of menu items for this page
   * @return menu
   */
  @Valid @Size(min = 0) 
  @Schema(name = "menu", description = "list of menu items for this page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("menu")
  public List<@Valid ViewerMenuItem> getMenu() {
    return menu;
  }

  public void setMenu(List<@Valid ViewerMenuItem> menu) {
    this.menu = menu;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageResponse pageResponse = (PageResponse) o;
    return Objects.equals(this.id, pageResponse.id) &&
        Objects.equals(this.type, pageResponse.type) &&
        Objects.equals(this.name, pageResponse.name) &&
        Objects.equals(this.title, pageResponse.title) &&
        Objects.equals(this.content, pageResponse.content) &&
        Objects.equals(this.className, pageResponse.className) &&
        Objects.equals(this.tiles, pageResponse.tiles) &&
        Objects.equals(this.menu, pageResponse.menu);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, name, title, content, className, tiles, menu);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageResponse {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    tiles: ").append(toIndentedString(tiles)).append("\n");
    sb.append("    menu: ").append(toIndentedString(menu)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

