/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration;

import java.io.InputStream;
import java.io.ObjectInputStream;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;

@Configuration
@EnableJdbcHttpSession
@Profile(value={"!test"})
public class JdbcSessionConfiguration {
    @Bean(value={"springSessionConversionService"})
    public ConversionService springSessionConversionService() {
        GenericConversionService converter = new GenericConversionService();
        converter.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        converter.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter((Deserializer)new CustomDeserializer()));
        return converter;
    }

    static class CustomDeserializer
    implements Deserializer<Object> {
        CustomDeserializer() {
        }

        public Object deserialize(InputStream inputStream) {
            Object object;
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            try {
                object = ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            ois.close();
            return object;
        }
    }
}

