/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.instrument.Metrics;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.prometheus.TagNames;
import org.tailormap.api.viewer.model.ViewerResponse;

@AppRestController
@Validated
public class IngestMetricsController
implements TagNames {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${tailormap-api.allowed-metrics}")
    private Set<String> allowedMetrics;

    @Operation(summary="Ingest a metric for the given application layer(s)", description="Ingests a metric for the given application layer(s), the metric will be published through the actuator endpoint as\na Micrometer counter. All application layers in the appLayerIds that are part of the application will be processed.\nThe metric must be one of the allowed metrics defined in the application configuration.")
    @PutMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/metrics/ingest/{appLayerIds}/{allowedMetric}"})
    public ResponseEntity<Serializable> ingestMetric(@ModelAttribute Application app, @ModelAttribute ViewerResponse.KindEnum viewerKind, @PathVariable Set<String> appLayerIds, @PathVariable String allowedMetric) {
        if (!this.allowedMetrics.contains(allowedMetric)) {
            logger.warn("Invalid metric: {}, not in allowed metrics: {}", (Object)allowedMetric, this.allowedMetrics);
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (appLayerIds.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        logger.trace("Ingesting metric for {} layer(s)", appLayerIds);
        app.getAllAppTreeLayerNode().filter(appTreeLayerNode -> appLayerIds.contains(appTreeLayerNode.getId())).forEach(appTreeLayerNode -> {
            logger.debug("Ingesting metric: {}, appId={}, viewerKind={}, appLayerId={} to be published through the actuator endpoint", new Object[]{allowedMetric, app.getId(), viewerKind, appTreeLayerNode.getId()});
            Metrics.counter((String)allowedMetric, (String[])new String[]{"appId", app.getId().toString(), "appType", viewerKind.name().toLowerCase(Locale.getDefault()), "appName", app.getName(), "appLayerId", appTreeLayerNode.getId()}).increment();
        });
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }
}

