/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import jakarta.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.repository.GeoServiceRepository;

@RestController
public class GeoServiceAdminController {
    private final GeoServiceRepository geoServiceRepository;
    private final ApplicationContext applicationContext;
    private final RepositoryEntityLinks repositoryEntityLinks;

    public GeoServiceAdminController(GeoServiceRepository geoServiceRepository, ApplicationContext applicationContext, RepositoryEntityLinks repositoryEntityLinks) {
        this.geoServiceRepository = geoServiceRepository;
        this.applicationContext = applicationContext;
        this.repositoryEntityLinks = repositoryEntityLinks;
    }

    @PostMapping(path={"${tailormap-api.admin.base-path}/geo-services/{id}/refresh-capabilities"})
    public ResponseEntity<GeoService> refreshCapabilities(@PathVariable String id, HttpServletResponse httpServletResponse) throws Exception {
        GeoService geoService = this.geoServiceRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        geoService.setRefreshCapabilities(true);
        this.applicationContext.publishEvent((ApplicationEvent)new BeforeSaveEvent((Object)geoService));
        this.geoServiceRepository.saveAndFlush(geoService);
        httpServletResponse.sendRedirect(String.valueOf(this.repositoryEntityLinks.linkToItemResource(GeoService.class, (Object)id).toUri()));
        return null;
    }
}

