/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import jakarta.persistence.EntityManager;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formattable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.tailormap.api.controller.GeoServiceProxyController;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.GeoServiceHelper;
import org.tailormap.api.persistence.helper.GeoToolsHelper;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.json.AppContent;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AppTreeLevelNode;
import org.tailormap.api.persistence.json.AppTreeNode;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.persistence.json.ServicePublishingSettings;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.repository.GeoServiceRepository;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.security.AuthorisationService;
import org.tailormap.api.util.TMStringUtils;
import org.tailormap.api.viewer.model.AppLayer;
import org.tailormap.api.viewer.model.LayerSearchIndex;
import org.tailormap.api.viewer.model.LayerTreeNode;
import org.tailormap.api.viewer.model.MapResponse;
import org.tailormap.api.viewer.model.TMCoordinateReferenceSystem;

@Service
public class ApplicationHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_WEB_MERCATOR_CRS = "EPSG:3857";
    private final GeoServiceHelper geoServiceHelper;
    private final GeoServiceRepository geoServiceRepository;
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final FeatureSourceRepository featureSourceRepository;
    private final EntityManager entityManager;
    private final AuthorisationService authorisationService;
    private final SearchIndexRepository searchIndexRepository;

    public ApplicationHelper(GeoServiceHelper geoServiceHelper, GeoServiceRepository geoServiceRepository, ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, FeatureSourceRepository featureSourceRepository, EntityManager entityManager, AuthorisationService authorisationService, SearchIndexRepository searchIndexRepository) {
        this.geoServiceHelper = geoServiceHelper;
        this.geoServiceRepository = geoServiceRepository;
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.featureSourceRepository = featureSourceRepository;
        this.entityManager = entityManager;
        this.authorisationService = authorisationService;
        this.searchIndexRepository = searchIndexRepository;
    }

    public Application getServiceApplication(String baseAppName, String projection, GeoService service) {
        Application app;
        if (baseAppName == null) {
            baseAppName = Optional.ofNullable(service.getSettings().getPublishing()).map(ServicePublishingSettings::getBaseApp).orElseGet(() -> this.configurationRepository.get("default-base-app"));
        }
        Application baseApp = null;
        if (baseAppName != null && (baseApp = this.applicationRepository.findByName(baseAppName)) != null) {
            this.entityManager.detach((Object)baseApp);
        }
        Application application = app = baseApp != null ? baseApp : new Application().setContentRoot(new AppContent());
        if (projection != null) {
            throw new UnsupportedOperationException("Projection filtering not yet supported");
        }
        projection = baseApp != null ? baseApp.getCrs() : DEFAULT_WEB_MERCATOR_CRS;
        app.setName(service.getId()).setTitle(service.getTitle()).setCrs(projection);
        return app;
    }

    @Transactional
    public MapResponse toMapResponse(Application app) {
        MapResponse mapResponse = new MapResponse();
        this.setCrsAndBounds(app, mapResponse);
        this.setLayers(app, mapResponse);
        return mapResponse;
    }

    public void setCrsAndBounds(Application a, MapResponse mapResponse) {
        CoordinateReferenceSystem gtCrs = a.getGeoToolsCoordinateReferenceSystem();
        if (gtCrs == null) {
            throw new IllegalArgumentException("Invalid CRS: " + a.getCrs());
        }
        TMCoordinateReferenceSystem crs = new TMCoordinateReferenceSystem().code(a.getCrs()).definition(((Formattable)gtCrs).toWKT(0)).bounds(GeoToolsHelper.fromCRS(gtCrs)).unit(Optional.ofNullable(CRSUtilities.getUnit((CoordinateSystem)gtCrs.getCoordinateSystem())).map(Objects::toString).orElse(null));
        Bounds maxExtent = a.getMaxExtent() != null ? a.getMaxExtent() : crs.getBounds();
        Bounds initialExtent = a.getInitialExtent() != null ? a.getInitialExtent() : maxExtent;
        mapResponse.crs(crs).maxExtent(maxExtent).initialExtent(initialExtent);
    }

    private void setLayers(Application app, MapResponse mr) {
        new MapResponseLayerBuilder(app, mr).buildLayers();
    }

    private String getProxyUrl(GeoService geoService, Application application, AppTreeLayerNode appTreeLayerNode) {
        String baseProxyUrl = WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("viewerKind", "app", "viewerName", application.getName(), "appLayerId", appTreeLayerNode.getId())).toString();
        String protocolPath = "/" + geoService.getProtocol().getValue();
        if (geoService.getProtocol() == GeoServiceProtocol.TILES3D) {
            return baseProxyUrl + protocolPath + "/tiles3dDescription";
        }
        return baseProxyUrl + protocolPath;
    }

    private String getLegendProxyUrl(Application application, AppTreeLayerNode appTreeLayerNode) {
        return String.valueOf(WebMvcLinkBuilder.linkTo(GeoServiceProxyController.class, Map.of("viewerKind", "app", "viewerName", application.getName(), "appLayerId", appTreeLayerNode.getId()))) + "/" + GeoServiceProtocol.LEGEND.getValue();
    }

    private class MapResponseLayerBuilder {
        private final Application app;
        private final MapResponse mapResponse;
        private final Map<GeoServiceLayer, String> serviceLayerServiceIds = new HashMap<GeoServiceLayer, String>();

        MapResponseLayerBuilder(Application app, MapResponse mapResponse) {
            this.app = app;
            this.mapResponse = mapResponse;
        }

        void buildLayers() {
            if (this.app.getContentRoot() != null) {
                this.buildBackgroundLayers();
                this.buildOverlayLayers();
                this.buildTerrainLayers();
            }
        }

        private void buildBackgroundLayers() {
            if (this.app.getContentRoot().getBaseLayerNodes() != null) {
                for (AppTreeNode node : this.app.getContentRoot().getBaseLayerNodes()) {
                    this.addAppTreeNodeItem(node, this.mapResponse.getBaseLayerTreeNodes());
                }
                Set<String> validLayerIds = this.mapResponse.getAppLayers().stream().map(AppLayer::getId).collect(Collectors.toSet());
                List<LayerTreeNode> initialLayerTreeNodes = this.mapResponse.getBaseLayerTreeNodes();
                this.mapResponse.setBaseLayerTreeNodes(this.cleanLayerTreeNodes(validLayerIds, initialLayerTreeNodes));
            }
        }

        private void buildOverlayLayers() {
            if (this.app.getContentRoot().getLayerNodes() != null) {
                for (AppTreeNode node : this.app.getContentRoot().getLayerNodes()) {
                    this.addAppTreeNodeItem(node, this.mapResponse.getLayerTreeNodes());
                }
                Set<String> validLayerIds = this.mapResponse.getAppLayers().stream().map(AppLayer::getId).collect(Collectors.toSet());
                List<LayerTreeNode> initialLayerTreeNodes = this.mapResponse.getLayerTreeNodes();
                this.mapResponse.setLayerTreeNodes(this.cleanLayerTreeNodes(validLayerIds, initialLayerTreeNodes));
            }
        }

        private List<LayerTreeNode> cleanLayerTreeNodes(Set<String> validLayerIds, List<LayerTreeNode> initialLayerTreeNodes) {
            List<String> levelNodes = initialLayerTreeNodes.stream().filter(n -> n.getAppLayerId() == null).map(LayerTreeNode::getId).toList();
            List<LayerTreeNode> newLayerTreeNodes = initialLayerTreeNodes.stream().peek(n -> n.getChildrenIds().removeIf(childId -> !validLayerIds.contains(childId) && !levelNodes.contains(childId))).filter(n -> n.getAppLayerId() != null || n.getChildrenIds() == null || !n.getChildrenIds().isEmpty()).toList();
            List<String> cleanLevelNodeIds = newLayerTreeNodes.stream().filter(n -> n.getAppLayerId() == null).map(LayerTreeNode::getId).toList();
            return newLayerTreeNodes.stream().peek(n -> n.getChildrenIds().removeIf(childId -> !cleanLevelNodeIds.contains(childId) && levelNodes.contains(childId))).toList();
        }

        private void buildTerrainLayers() {
            if (this.app.getContentRoot().getTerrainLayerNodes() != null) {
                for (AppTreeNode node : this.app.getContentRoot().getTerrainLayerNodes()) {
                    this.addAppTreeNodeItem(node, this.mapResponse.getTerrainLayerTreeNodes());
                }
            }
        }

        private void addAppTreeNodeItem(AppTreeNode node, List<LayerTreeNode> layerTreeNodeList) {
            LayerTreeNode layerTreeNode = new LayerTreeNode();
            if ("AppTreeLayerNode".equals(node.getObjectType())) {
                AppTreeLayerNode appTreeLayerNode = (AppTreeLayerNode)node;
                layerTreeNode.setId(appTreeLayerNode.getId());
                layerTreeNode.setAppLayerId(appTreeLayerNode.getId());
                if (!this.addAppLayerItem(appTreeLayerNode)) {
                    return;
                }
                layerTreeNode.setName(appTreeLayerNode.getLayerName());
                layerTreeNode.setDescription(appTreeLayerNode.getDescription());
            } else if ("AppTreeLevelNode".equals(node.getObjectType())) {
                AppTreeLevelNode appTreeLevelNode = (AppTreeLevelNode)node;
                layerTreeNode.setId(appTreeLevelNode.getId());
                layerTreeNode.setChildrenIds(appTreeLevelNode.getChildrenIds());
                layerTreeNode.setRoot(Boolean.TRUE.equals(appTreeLevelNode.getRoot()));
                layerTreeNode.setName(appTreeLevelNode.getTitle());
                layerTreeNode.setDescription(appTreeLevelNode.getDescription());
            }
            layerTreeNodeList.add(layerTreeNode);
        }

        private boolean addAppLayerItem(AppTreeLayerNode layerRef) {
            ServiceLayerInfo layerInfo = this.findServiceLayer(layerRef);
            if (layerInfo == null) {
                return false;
            }
            GeoService service = layerInfo.service();
            GeoServiceLayer serviceLayer = layerInfo.serviceLayer();
            GeoServiceDefaultLayerSettings defaultLayerSettings = Optional.ofNullable(service.getSettings().getDefaultLayerSettings()).orElseGet(GeoServiceDefaultLayerSettings::new);
            GeoServiceLayerSettings serviceLayerSettings = Optional.ofNullable(layerInfo.layerSettings()).orElseGet(GeoServiceLayerSettings::new);
            AppLayerSettings appLayerSettings = this.app.getAppLayerSettings(layerRef);
            String title = Objects.requireNonNullElse(TMStringUtils.nullIfEmpty(appLayerSettings.getTitle()), service.getTitleWithSettingsOverrides(layerRef.getLayerName()));
            String description = (String)ObjectUtils.firstNonNull((Object[])new String[]{TMStringUtils.nullIfEmpty(appLayerSettings.getDescription()), TMStringUtils.nullIfEmpty(serviceLayerSettings.getDescription()), TMStringUtils.nullIfEmpty(defaultLayerSettings.getDescription())});
            String attribution = (String)ObjectUtils.firstNonNull((Object[])new String[]{TMStringUtils.nullIfEmpty(appLayerSettings.getAttribution()), TMStringUtils.nullIfEmpty(serviceLayerSettings.getAttribution()), TMStringUtils.nullIfEmpty(defaultLayerSettings.getAttribution())});
            boolean tilingDisabled = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{serviceLayerSettings.getTilingDisabled(), defaultLayerSettings.getTilingDisabled(), true});
            Integer tilingGutter = (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{serviceLayerSettings.getTilingGutter(), defaultLayerSettings.getTilingGutter(), 0});
            boolean hiDpiDisabled = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{serviceLayerSettings.getHiDpiDisabled(), defaultLayerSettings.getHiDpiDisabled(), true});
            TileLayerHiDpiMode hiDpiMode = (TileLayerHiDpiMode)ObjectUtils.firstNonNull((Object[])new TileLayerHiDpiMode[]{serviceLayerSettings.getHiDpiMode(), defaultLayerSettings.getHiDpiMode(), null});
            String hiDpiSubstituteLayer = serviceLayerSettings.getHiDpiSubstituteLayer();
            TMFeatureType tmft = service.findFeatureTypeForLayer(serviceLayer, ApplicationHelper.this.featureSourceRepository);
            boolean proxied = service.getSettings().getUseProxy();
            String legendImageUrl = serviceLayerSettings.getLegendImageId();
            AppLayer.LegendTypeEnum legendType = AppLayer.LegendTypeEnum.STATIC;
            if (legendImageUrl == null && serviceLayer.getStyles() != null && (legendImageUrl = (String)Optional.ofNullable(GeoServiceHelper.getLayerLegendUrlFromStyles(service, serviceLayer)).map(URI::toString).orElse(null)) != null) {
                AppLayer.LegendTypeEnum legendTypeEnum = legendType = "GetLegendGraphic".equalsIgnoreCase(GeoServiceHelper.getWmsRequest(legendImageUrl)) ? AppLayer.LegendTypeEnum.DYNAMIC : AppLayer.LegendTypeEnum.STATIC;
                if (proxied) {
                    legendImageUrl = ApplicationHelper.this.getLegendProxyUrl(this.app, layerRef);
                }
            }
            SearchIndex searchIndex = null;
            if (appLayerSettings.getSearchIndexId() != null) {
                searchIndex = ApplicationHelper.this.searchIndexRepository.findById(appLayerSettings.getSearchIndexId()).orElse(null);
            }
            boolean webMercatorAvailable = this.isWebMercatorAvailable(service, serviceLayer, hiDpiSubstituteLayer);
            this.mapResponse.addAppLayersItem(new AppLayer().id(layerRef.getId()).serviceId(this.serviceLayerServiceIds.get(serviceLayer)).layerName(layerRef.getLayerName()).hasAttributes(tmft != null).editable(TMFeatureTypeHelper.isEditable(this.app, layerRef, tmft)).url(proxied ? ApplicationHelper.this.getProxyUrl(service, this.app, layerRef) : null).maxScale(serviceLayer.getMaxScale()).minScale(serviceLayer.getMinScale()).title(title).tilingDisabled(tilingDisabled).tilingGutter(tilingGutter).hiDpiDisabled(hiDpiDisabled).hiDpiMode(hiDpiMode).hiDpiSubstituteLayer(hiDpiSubstituteLayer).minZoom(serviceLayerSettings.getMinZoom()).maxZoom(serviceLayerSettings.getMaxZoom()).tileSize(serviceLayerSettings.getTileSize()).tileGridExtent(serviceLayerSettings.getTileGridExtent()).opacity(appLayerSettings.getOpacity()).autoRefreshInSeconds(appLayerSettings.getAutoRefreshInSeconds()).searchIndex(searchIndex != null ? new LayerSearchIndex().id(searchIndex.getId()).name(searchIndex.getName()) : null).legendImageUrl(legendImageUrl).legendType(legendType).visible(layerRef.getVisible()).attribution(attribution).description(description).webMercatorAvailable(webMercatorAvailable).hiddenFunctionality(appLayerSettings.getHiddenFunctionality()));
            return true;
        }

        private ServiceLayerInfo findServiceLayer(AppTreeLayerNode layerRef) {
            GeoService service = ApplicationHelper.this.geoServiceRepository.findById(layerRef.getServiceId()).orElse(null);
            if (service == null) {
                logger.warn("App {} references layer \"{}\" of missing service {}", new Object[]{this.app.getId(), layerRef.getLayerName(), layerRef.getServiceId()});
                return null;
            }
            if (ApplicationHelper.this.authorisationService.mustDenyAccessForSecuredProxy(service)) {
                return null;
            }
            if (!ApplicationHelper.this.authorisationService.userAllowedToViewGeoService(service)) {
                return null;
            }
            GeoServiceLayer serviceLayer = service.findLayer(layerRef.getLayerName());
            if (serviceLayer == null) {
                logger.warn("App {} references layer \"{}\" not found in capabilities of service {}", new Object[]{this.app.getId(), layerRef.getLayerName(), service.getId()});
                return null;
            }
            if (!ApplicationHelper.this.authorisationService.userAllowedToViewGeoServiceLayer(service, serviceLayer)) {
                logger.debug("User not allowed to view layer {} of service {}", (Object)serviceLayer.getName(), (Object)service.getId());
                return null;
            }
            this.serviceLayerServiceIds.put(serviceLayer, service.getId());
            if (this.mapResponse.getServices().stream().filter(s -> s.getId().equals(service.getId())).findAny().isEmpty()) {
                this.mapResponse.addServicesItem(service.toJsonPojo(ApplicationHelper.this.geoServiceHelper));
            }
            GeoServiceLayerSettings layerSettings = service.getLayerSettings(layerRef.getLayerName());
            return new ServiceLayerInfo(service, serviceLayer, layerSettings);
        }

        private boolean isWebMercatorAvailable(GeoService service, GeoServiceLayer serviceLayer, String hiDpiSubstituteLayer) {
            GeoServiceLayer hiDpiSubstituteServiceLayer;
            if (service.getProtocol() == GeoServiceProtocol.XYZ) {
                return ApplicationHelper.DEFAULT_WEB_MERCATOR_CRS.equals(service.getSettings().getXyzCrs());
            }
            if (service.getProtocol() == GeoServiceProtocol.TILES3D || service.getProtocol() == GeoServiceProtocol.QUANTIZEDMESH) {
                return false;
            }
            if (hiDpiSubstituteLayer != null && (hiDpiSubstituteServiceLayer = service.findLayer(hiDpiSubstituteLayer)) != null && !this.isWebMercatorAvailable(service, hiDpiSubstituteServiceLayer, null)) {
                return false;
            }
            while (serviceLayer != null) {
                Set<String> layerCrs = serviceLayer.getCrs();
                if (layerCrs.contains(ApplicationHelper.DEFAULT_WEB_MERCATOR_CRS)) {
                    return true;
                }
                if (serviceLayer.getRoot().booleanValue()) break;
                serviceLayer = service.getParentLayer(serviceLayer.getId());
            }
            return false;
        }

        record ServiceLayerInfo(GeoService service, GeoServiceLayer serviceLayer, GeoServiceLayerSettings layerSettings) {
        }
    }
}

