/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.Filter;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="FilterGroup", description="A group of filters. The group can be used to group filters together, or to disable a group of filters.")
public class FilterGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String source;
    @Valid
    private List<String> layerIds = new ArrayList<String>();
    private TypeEnum type;
    private OperatorEnum operator = OperatorEnum.AND;
    @Valid
    private @Valid List<@Valid Filter> filters = new ArrayList<Filter>();
    private Boolean disabled = null;
    private String parentGroup = null;

    public FilterGroup id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="id of the filter group", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FilterGroup source(String source) {
        this.source = source;
        return this;
    }

    @Schema(name="source", description="source of the filter group", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public FilterGroup layerIds(List<String> layerIds) {
        this.layerIds = layerIds;
        return this;
    }

    public FilterGroup addLayerIdsItem(String layerIdsItem) {
        if (this.layerIds == null) {
            this.layerIds = new ArrayList<String>();
        }
        this.layerIds.add(layerIdsItem);
        return this;
    }

    @Size(min=1)
    @Schema(name="layerIds", description="list of layer ids", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerIds")
    public @Size(min=1) List<String> getLayerIds() {
        return this.layerIds;
    }

    public void setLayerIds(List<String> layerIds) {
        this.layerIds = layerIds;
    }

    public FilterGroup type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="NOTE spatial is not supported (for now) for preconfigured filters", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FilterGroup operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Schema(name="operator", description="The operator for the filter group, we may want to support the OR operator in the future", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public FilterGroup filters(List<@Valid Filter> filters) {
        this.filters = filters;
        return this;
    }

    public FilterGroup addFiltersItem(Filter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Valid
    @Size(min=1)
    @Schema(name="filters", description="A list of filters", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filters")
    public @Valid @Size(min=1) List<@Valid Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<@Valid Filter> filters) {
        this.filters = filters;
    }

    public FilterGroup disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Schema(name="disabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public FilterGroup parentGroup(String parentGroup) {
        this.parentGroup = parentGroup;
        return this;
    }

    @Schema(name="parentGroup", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="parentGroup")
    public String getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(String parentGroup) {
        this.parentGroup = parentGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterGroup filterGroup = (FilterGroup)o;
        return Objects.equals(this.id, filterGroup.id) && Objects.equals(this.source, filterGroup.source) && Objects.equals(this.layerIds, filterGroup.layerIds) && Objects.equals((Object)this.type, (Object)filterGroup.type) && Objects.equals((Object)this.operator, (Object)filterGroup.operator) && Objects.equals(this.filters, filterGroup.filters) && Objects.equals(this.disabled, filterGroup.disabled) && Objects.equals(this.parentGroup, filterGroup.parentGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.source, this.layerIds, this.type, this.operator, this.filters, this.disabled, this.parentGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterGroup {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    layerIds: ").append(this.toIndentedString(this.layerIds)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    parentGroup: ").append(this.toIndentedString(this.parentGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperatorEnum {
        AND("AND"),
        OR("OR");

        private final String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ATTRIBUTE("ATTRIBUTE");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

