/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import io.micrometer.core.annotation.Timed;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.tailormap.api.prometheus.PrometheusService;
import org.tailormap.api.scheduling.Task;
import org.tailormap.api.scheduling.TaskType;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class PrometheusPingTask
extends QuartzJobBean
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PrometheusService prometheusService;

    public PrometheusPingTask(PrometheusService prometheusService) {
        this.prometheusService = prometheusService;
    }

    @Timed(value="prometheusServiceTask", description="Time taken to ping prometheus")
    protected void executeInternal(@NonNull JobExecutionContext context) throws JobExecutionException {
        JobDataMap persistedJobData = context.getJobDetail().getJobDataMap();
        if (!this.prometheusService.isPrometheusAvailable()) {
            logger.warn("PrometheusService is not available");
            persistedJobData.put("lastResult", "Prometheus is not available. Check failed.");
            context.setResult((Object)"Prometheus is not available");
        } else {
            persistedJobData.put("lastResult", "Prometheus is available. Check succeeded.");
            context.setResult((Object)"Prometheus is available");
        }
        persistedJobData.put("lastExecutionFinished", (Object)Instant.now());
    }

    @Override
    public TaskType getType() {
        return TaskType.PROMETHEUS_PING;
    }

    @Override
    public String getDescription() {
        return "Ping Prometheus to ensure it is available.";
    }

    @Override
    public void setDescription(String description) {
    }
}

