/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Service;
import org.tailormap.api.scheduling.TMJobDataMap;
import org.tailormap.api.scheduling.TaskType;

@Service
public class TaskManagerService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Scheduler scheduler;

    public TaskManagerService(@Autowired Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public UUID createTask(Class<? extends QuartzJobBean> job, TMJobDataMap jobData) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(job).withIdentity(new JobKey(UUID.randomUUID().toString(), jobData.get("type").toString())).withDescription(jobData.getDescription()).usingJobData(new JobDataMap((Map)jobData)).storeDurably(false).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobDetail.getKey().getName(), jobDetail.getKey().getGroup()).startNow().withPriority(jobData.getPriority()).usingJobData("sentry-slug", "monitor_slug_simple_trigger_" + String.valueOf(jobData.get("type"))).forJob(jobDetail).build();
        this.scheduler.scheduleJob(jobDetail, Set.of(trigger), true);
        return UUID.fromString(jobDetail.getKey().getName());
    }

    public UUID createTask(Class<? extends QuartzJobBean> job, TMJobDataMap jobData, String cronExpression) throws SchedulerException {
        JobDetail jobDetail = JobBuilder.newJob(job).withIdentity(new JobKey(UUID.randomUUID().toString(), jobData.get("type").toString())).withDescription(jobData.getDescription()).usingJobData(new JobDataMap((Map)jobData)).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobDetail.getKey().getName(), jobDetail.getKey().getGroup()).startAt(DateBuilder.futureDate((int)90, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withPriority(jobData.getPriority()).usingJobData("sentry-slug", "monitor_slug_cron_trigger_" + String.valueOf(jobData.get("type"))).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed()).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (ObjectAlreadyExistsException ex) {
            logger.warn("Job {} with trigger {} has not bean added to scheduler as it already exists.", (Object)jobDetail.getKey(), (Object)trigger.getKey());
            return null;
        }
        return UUID.fromString(jobDetail.getKey().getName());
    }

    public void updateTask(JobKey jobKey, TMJobDataMap newJobData) throws SchedulerException {
        Trigger oldTrigger;
        if (this.scheduler.checkExists(jobKey) && this.scheduler.checkExists((oldTrigger = (Trigger)this.scheduler.getTriggersOfJob(jobKey).get(0)).getKey())) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.putAll((Map)newJobData);
            Trigger newTrigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName(), jobKey.getGroup()).startAt(DateBuilder.futureDate((int)90, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).withPriority(jobDataMap.getInt("priority")).usingJobData("sentry-slug", "monitor_slug_cron_trigger_" + jobDataMap.get((Object)"type").toString()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobDataMap.getString("cronExpression")).withMisfireHandlingInstructionFireAndProceed()).build();
            this.scheduler.addJob(jobDetail, true, true);
            this.scheduler.rescheduleJob(oldTrigger.getKey(), newTrigger);
        }
    }

    @Nullable
    public JobKey getJobKey(TaskType jobType, UUID uuid) throws SchedulerException {
        logger.debug("Finding job key for task {}:{}", (Object)jobType, (Object)uuid);
        return this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)jobType.getValue())).stream().filter(jobkey -> jobkey.getName().equals(uuid.toString())).findFirst().orElse(null);
    }

    public void deleteTasksByGroupName(String groupName) throws SchedulerException {
        logger.debug("Deleting tasks in group: {}", (Object)groupName);
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)groupName));
        for (JobKey jobKey : jobKeys) {
            logger.info("Deleting task: {}", (Object)jobKey);
            this.scheduler.deleteJob(jobKey);
        }
    }
}

