/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.AuthorizationRuleDecision;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;

@Service
public class AuthorisationService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACCESS_TYPE_VIEW = "read";

    private Optional<AuthorizationRuleDecision> isAuthorizedByRules(List<AuthorizationRule> rules) {
        Set<String> groups;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || auth instanceof AnonymousAuthenticationToken) {
            groups = Set.of("anonymous");
        } else {
            groups = new HashSet<String>();
            groups.add("anonymous");
            groups.add("authenticated");
            for (GrantedAuthority authority : auth.getAuthorities()) {
                groups.add(authority.getAuthority());
            }
        }
        logger.trace("Groups to check rules against: {}", groups);
        if (groups.contains("admin")) {
            logger.trace("Returning {} because {} is allowed access to anything.", (Object)AuthorizationRuleDecision.ALLOW, (Object)"admin");
            return Optional.of(AuthorizationRuleDecision.ALLOW);
        }
        boolean hasValidRule = false;
        for (AuthorizationRule rule : rules) {
            boolean matchesGroup;
            if (logger.isTraceEnabled()) {
                logger.trace("Checking rule: \n{} against groups {}.", (Object)rule, groups);
            }
            if (!(matchesGroup = groups.contains(rule.getGroupName()))) continue;
            hasValidRule = true;
            AuthorizationRuleDecision value = rule.getDecisions().get(ACCESS_TYPE_VIEW);
            if (value == null) {
                logger.trace("No decision found for rule: \n{} and access: {}, returning <EMPTY>.", (Object)rule, (Object)ACCESS_TYPE_VIEW);
                return Optional.empty();
            }
            if (!value.equals(AuthorizationRuleDecision.ALLOW)) continue;
            logger.trace("Returning {} because rule: \n{} allows {} access for access: {}.", new Object[]{value, rule, rule.getGroupName(), ACCESS_TYPE_VIEW});
            return Optional.of(value);
        }
        if (hasValidRule) {
            logger.trace("Returning {} because no valid rule allowed access for access: {}.", (Object)AuthorizationRuleDecision.DENY, (Object)ACCESS_TYPE_VIEW);
            return Optional.of(AuthorizationRuleDecision.DENY);
        }
        logger.trace("Returning <EMPTY> because no rules matched for access: {}.", (Object)ACCESS_TYPE_VIEW);
        return Optional.empty();
    }

    public boolean userAllowedToViewApplication(Application application) {
        logger.trace("Checking if user is allowed to view Application {} ({}).", (Object)application.getTitle(), (Object)application.getTitle());
        boolean allowed = this.isAuthorizedByRules(application.getAuthorizationRules()).equals(Optional.of(AuthorizationRuleDecision.ALLOW));
        logger.trace("User is{} allowed to view application: {} (isAuthorizedByRules={}).", new Object[]{allowed ? "" : " not", application.getName(), allowed});
        return allowed;
    }

    public boolean userAllowedToViewGeoService(GeoService geoService) {
        logger.trace("Checking if user is allowed to view GeoService {} ({}).", (Object)geoService.getId(), (Object)geoService.getTitle());
        boolean allowed = this.isAuthorizedByRules(geoService.getAuthorizationRules()).equals(Optional.of(AuthorizationRuleDecision.ALLOW));
        logger.trace("User is{} allowed to view GeoService: {} (isAuthorizedByRules={}).", new Object[]{allowed ? "" : " not", geoService.getTitle(), allowed});
        return allowed;
    }

    public boolean userAllowedToViewGeoServiceLayer(GeoService geoService, GeoServiceLayer layer) {
        logger.trace("Checking if user is allowed to view GeoService '{}' and layer {} ({}).", new Object[]{geoService.getTitle(), layer.getName(), layer.getTitle()});
        Optional<AuthorizationRuleDecision> geoserviceDecision = this.isAuthorizedByRules(geoService.getAuthorizationRules());
        if (geoserviceDecision.equals(Optional.of(AuthorizationRuleDecision.DENY))) {
            logger.trace("Viewing GeoService {} is denied for user.", (Object)geoService.getTitle());
            return false;
        }
        GeoServiceLayerSettings layerSettings = geoService.getSettings().getLayerSettings().get(layer.getName());
        if (layerSettings != null && layerSettings.getAuthorizationRules() != null) {
            logger.trace("Checking layer settings rules for GeoService '{}' and layer '{}'. \nRules: {}", new Object[]{geoService.getTitle(), layer.getName(), layerSettings.getAuthorizationRules()});
            ArrayList<AuthorizationRule> combinedRules = new ArrayList<AuthorizationRule>(geoService.getAuthorizationRules());
            for (AuthorizationRule rule : layerSettings.getAuthorizationRules()) {
                combinedRules.removeIf(r -> r.getGroupName().equals(rule.getGroupName()));
                combinedRules.add(rule);
            }
            logger.trace("Combined rules for GeoService '{}' and layer '{}': \n{}", new Object[]{geoService.getTitle(), layer.getName(), combinedRules});
            Optional<AuthorizationRuleDecision> decision = this.isAuthorizedByRules(combinedRules);
            if (decision.isPresent() || !layerSettings.getAuthorizationRules().isEmpty()) {
                boolean allowed = decision.equals(Optional.of(AuthorizationRuleDecision.ALLOW));
                logger.trace("Viewing GeoService '{}' and layer '{}' ({}) is {} for user.", new Object[]{geoService.getTitle(), layer.getName(), layer.getTitle(), allowed ? "allowed" : "denied"});
                return allowed;
            }
        }
        boolean allowed = geoserviceDecision.equals(Optional.of(AuthorizationRuleDecision.ALLOW));
        logger.trace("Viewing GeoService '{}' and layer '{}' ({}) is {} for user because service access is {3}.", new Object[]{geoService.getTitle(), layer.getName(), layer.getTitle(), allowed ? "allowed" : "denied"});
        return allowed;
    }

    public boolean mustDenyAccessForSecuredProxy(GeoService geoService) {
        if (!Boolean.TRUE.equals(geoService.getSettings().getUseProxy())) {
            return false;
        }
        if (geoService.getAuthentication() == null) {
            return false;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth == null || auth instanceof AnonymousAuthenticationToken;
    }
}

