/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.tailormap.api.persistence.Group;
import org.tailormap.api.persistence.User;
import org.tailormap.api.persistence.json.AdminAdditionalProperty;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.security.TailormapAdditionalProperty;
import org.tailormap.api.security.TailormapUserDetails;

class TailormapUserDetailsImpl
implements TailormapUserDetails {
    private static final long serialVersionUID = 1L;
    private final Collection<GrantedAuthority> authorities;
    private final String username;
    private final String password;
    private final ZonedDateTime validUntil;
    private final boolean enabled;
    private final Collection<TailormapAdditionalProperty> additionalProperties = new ArrayList<TailormapAdditionalProperty>();
    private final Collection<TailormapAdditionalProperty> additionalGroupProperties = new ArrayList<TailormapAdditionalProperty>();

    public TailormapUserDetailsImpl(User user, GroupRepository groupRepository) {
        this.authorities = new HashSet<GrantedAuthority>();
        user.getGroups().stream().map(Group::getName).map(SimpleGrantedAuthority::new).forEach(this.authorities::add);
        user.getGroups().stream().map(Group::getAliasForGroup).filter(StringUtils::isNotBlank).map(SimpleGrantedAuthority::new).forEach(this.authorities::add);
        this.username = user.getUsername();
        this.password = user.getPassword();
        this.validUntil = user.getValidUntil();
        this.enabled = user.isEnabled();
        if (user.getAdditionalProperties() != null) {
            for (AdminAdditionalProperty property : user.getAdditionalProperties()) {
                this.additionalProperties.add(new TailormapAdditionalProperty(property.getKey(), property.getIsPublic(), property.getValue()));
            }
        }
        this.additionalGroupProperties.addAll(groupRepository.findAdditionalPropertiesByGroups(this.authorities.stream().map(GrantedAuthority::getAuthority).toList()));
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.validUntil == null || this.validUntil.isAfter(ZonedDateTime.now(ZoneId.systemDefault()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Collection<TailormapAdditionalProperty> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Collection<TailormapAdditionalProperty> getAdditionalGroupProperties() {
        return this.additionalGroupProperties;
    }
}

