/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(name="ViewerPageTile", description="model for a page tile as returned by the api for the viewer")
public class ViewerPageTile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private String content;
    private String image = null;
    private String applicationUrl = null;
    private String pageUrl = null;
    private String url = null;
    private String className = null;
    private Boolean applicationRequiresLogin = null;
    private Boolean openInNewWindow = null;

    public ViewerPageTile title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="page tile title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ViewerPageTile content(String content) {
        this.content = content;
        return this;
    }

    @Schema(name="content", description="page tile contents", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ViewerPageTile image(String image) {
        this.image = image;
        return this;
    }

    @Schema(name="image", description="image to show on the tile", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ViewerPageTile applicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
        return this;
    }

    @Schema(name="applicationUrl", description="link to the application", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="applicationUrl")
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public ViewerPageTile pageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    @Schema(name="pageUrl", description="link to another page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageUrl")
    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public ViewerPageTile url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="link to an other domain / website", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ViewerPageTile className(String className) {
        this.className = className;
        return this;
    }

    @Schema(name="className", description="optional css classname for styling", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="className")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ViewerPageTile applicationRequiresLogin(Boolean applicationRequiresLogin) {
        this.applicationRequiresLogin = applicationRequiresLogin;
        return this;
    }

    @Schema(name="applicationRequiresLogin", description="indicates if the user will need to login for the linked application", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="applicationRequiresLogin")
    public Boolean getApplicationRequiresLogin() {
        return this.applicationRequiresLogin;
    }

    public void setApplicationRequiresLogin(Boolean applicationRequiresLogin) {
        this.applicationRequiresLogin = applicationRequiresLogin;
    }

    public ViewerPageTile openInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
        return this;
    }

    @Schema(name="openInNewWindow", description="indicates whether the link should be opened in a new window", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="openInNewWindow")
    public Boolean getOpenInNewWindow() {
        return this.openInNewWindow;
    }

    public void setOpenInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewerPageTile viewerPageTile = (ViewerPageTile)o;
        return Objects.equals(this.title, viewerPageTile.title) && Objects.equals(this.content, viewerPageTile.content) && Objects.equals(this.image, viewerPageTile.image) && Objects.equals(this.applicationUrl, viewerPageTile.applicationUrl) && Objects.equals(this.pageUrl, viewerPageTile.pageUrl) && Objects.equals(this.url, viewerPageTile.url) && Objects.equals(this.className, viewerPageTile.className) && Objects.equals(this.applicationRequiresLogin, viewerPageTile.applicationRequiresLogin) && Objects.equals(this.openInNewWindow, viewerPageTile.openInNewWindow);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.content, this.image, this.applicationUrl, this.pageUrl, this.url, this.className, this.applicationRequiresLogin, this.openInNewWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewerPageTile {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    applicationUrl: ").append(this.toIndentedString(this.applicationUrl)).append("\n");
        sb.append("    pageUrl: ").append(this.toIndentedString(this.pageUrl)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    applicationRequiresLogin: ").append(this.toIndentedString(this.applicationRequiresLogin)).append("\n");
        sb.append("    openInNewWindow: ").append(this.toIndentedString(this.openInNewWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

