/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration;

import jakarta.annotation.PostConstruct;
import java.util.List;
import org.flywaydb.core.api.output.MigrateResult;
import org.springframework.context.annotation.Configuration;
import org.tailormap.api.configuration.ddl.FlywayMigrationResult;
import org.tailormap.api.persistence.Catalog;
import org.tailormap.api.persistence.json.CatalogNode;
import org.tailormap.api.repository.CatalogRepository;
import org.tailormap.api.security.InternalAdminAuthentication;

@Configuration
public class TailormapDatabaseMigration {
    private final CatalogRepository catalogRepository;
    private final FlywayMigrationResult migrationResult;

    public TailormapDatabaseMigration(CatalogRepository catalogRepository, FlywayMigrationResult migrationResult) {
        this.catalogRepository = catalogRepository;
        this.migrationResult = migrationResult;
    }

    @PostConstruct
    public void databaseMigration() {
        MigrateResult migrateResult = this.migrationResult.getMigrateResult();
        if (migrateResult == null || migrateResult.migrationsExecuted == 0) {
            return;
        }
        InternalAdminAuthentication.setInSecurityContext();
        try {
            if (migrateResult.migrations.stream().anyMatch(m -> "1".equals(m.version))) {
                this.createRootCatalog();
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
    }

    private void createRootCatalog() {
        Catalog catalog = new Catalog().setId("main").setNodes(List.of(new CatalogNode().root(Boolean.valueOf(true)).title("root").id("root")));
        this.catalogRepository.save((Object)catalog);
    }
}

