/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.prometheus.PrometheusResultProcessor;
import org.tailormap.api.prometheus.PrometheusService;
import org.tailormap.api.prometheus.TagNames;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.scheduling.PrometheusPingTask;
import org.tailormap.api.scheduling.TMJobDataMap;
import org.tailormap.api.scheduling.TaskManagerService;
import org.tailormap.api.scheduling.TaskType;
import org.tailormap.api.viewer.model.ErrorResponse;

@RestController
public class PrometheusDataController
implements TagNames,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PrometheusService prometheusService;
    private final PrometheusResultProcessor prometheusResultProcessor;
    private final ApplicationRepository applicationRepository;
    private final TaskManagerService taskManagerService;
    @Value(value="${tailormap-api.prometheus-api-appmetrics-totals}")
    private String totalsQuery;
    @Value(value="${tailormap-api.prometheus-api-appmetrics-updated}")
    private String counterLastUpdatedQuery;
    @Value(value="${tailormap-api.prometheus-api-appmetrics-layer-switched-on}")
    private String appLayersSwitchedOnTotalsQuery;
    @Value(value="${tailormap-api.prometheus-api-appmetrics-layer-switched-on-updated}")
    private String appLayersSwitchedOnLastUpdatedQuery;
    @Value(value="${tailormap-api.prometheus-api-ping-cron:0 0/5 * 1/1 * ? *}")
    private String prometheusPingCron;

    public PrometheusDataController(PrometheusService prometheusService, PrometheusResultProcessor prometheusResultProcessor, ApplicationRepository applicationRepository, TaskManagerService taskManagerService) {
        this.prometheusService = prometheusService;
        this.prometheusResultProcessor = prometheusResultProcessor;
        this.applicationRepository = applicationRepository;
        this.taskManagerService = taskManagerService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.prometheusService.isPrometheusAvailable()) {
            logger.info("Prometheus is available, initializing PrometheusDataController.");
            try {
                this.taskManagerService.deleteTasksByGroupName(TaskType.PROMETHEUS_PING.getValue());
                UUID taskUuid = this.taskManagerService.createTask(PrometheusPingTask.class, new TMJobDataMap(Map.of("type", TaskType.PROMETHEUS_PING.getValue(), "description", "Ping Prometheus service for availability.", "priority", 57)), this.prometheusPingCron);
                logger.debug("Added Prometheus ping task with UUID: {}", (Object)taskUuid);
            }
            catch (Exception e) {
                logger.error("Error initializing Prometheus ping task", (Throwable)e);
            }
        } else {
            logger.info("Prometheus is not available, /graph/ endpoint will not be functional.");
        }
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<?> handleException(ResponseStatusException ex) {
        return ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(ex.getReason() != null ? ex.getReason() : ex.getBody().getTitle()).code(Integer.valueOf(ex.getStatusCode().value())));
    }

    @Operation(summary="retrieve application graph data", description="Fetches the totals and last updated time for application metrics from Prometheus.")
    @GetMapping(path={"${tailormap-api.admin.base-path}/graph/applications"}, produces={"application/json"})
    @ApiResponse(responseCode="200", description="Array of application metrics with totals and last updated times.", content={@Content(mediaType="application/json", schema=@Schema(example="{\"applications\":[\n{\"lastUpdateSecondsAgo\":\"85746\",\"appName\":\"default\",\"appId\":\"1\",\"totalCount\":\"4003\"},\n{\"lastUpdateSecondsAgo\":\"1345\",\"appName\":\"test\",\"appId\":\"5\",\"totalCount\":\"5\"}\n]}\n"))})
    public ResponseEntity<?> getApplicationGraphicData(@RequestParam(defaultValue="30") int numberOfDays) {
        if (numberOfDays < 1) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid number of days provided.");
        }
        if (!this.prometheusService.isPrometheusAvailable()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Prometheus is not available.");
        }
        String completeQuery = "label_replace(" + this.totalsQuery.replace("#NUMBER_OF_DAYS#", String.valueOf(numberOfDays)) + ", \"type\", \"totalCount\", \"__name__\", \".*\") or label_replace(" + this.counterLastUpdatedQuery.replace("#NUMBER_OF_DAYS#", String.valueOf(numberOfDays)) + ", \"type\", \"lastUpdateSecondsAgo\", \"__name__\", \".*\")";
        logger.trace("Fetching application graph data using query {}.", (Object)completeQuery);
        try {
            JsonNode totals = this.prometheusService.executeQuery(completeQuery);
            logger.trace("Application graph data fetched successfully. {}", (Object)totals.toPrettyString());
            Collection applications = this.prometheusResultProcessor.processPrometheusResultsForApplications(totals);
            return ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().set("applications", new ObjectMapper().valueToTree((Object)applications)));
        }
        catch (IOException e) {
            logger.error("Error fetching application graph data", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Operation(summary="retrieve application layers graph data", description="Fetches the totals and last updated time for application layer metrics from Prometheus.")
    @GetMapping(path={"${tailormap-api.admin.base-path}/graph/applayers/{applicationId}"}, produces={"application/json"})
    @ApiResponse(responseCode="200", description="Array of application layer metrics with totals and last updated times.", content={@Content(mediaType="application/json", schema=@Schema(example="{\"applicationLayers\":[\n{\"lastUpdateSecondsAgo\":\"3748\",\"appLayerName\":\"osm\",\"appName\":\"default\",\"appId\":\"1\",\"appLayerId\":\"lyr:openbasiskaart:osm\",\"totalCount\":\"1973\",\"appLayerTitle\":\"Openbasiskaart\"},\n{\"lastUpdateSecondsAgo\":\"3748\",\"appLayerName\":\"postgis:bak\",\"appName\":\"default\",\"appId\":\"1\",\"appLayerId\":\"lyr:snapshot-geoserver:postgis:bak\",\"totalCount\":\"2361\",\"appLayerTitle\":null},\n{\"lastUpdateSecondsAgo\":\"3748\",\"appLayerName\":\"postgis:begroeidterreindeel\",\"appName\":\"default\",\"appId\":\"1\",\"appLayerId\":\"lyr:snapshot-geoserver:postgis:begroeidterreindeel\",\"totalCount\":\"2323\",\"appLayerTitle\":null},\n{\"lastUpdateSecondsAgo\":\"3748\",\"appLayerName\":\"postgis:kadastraal_perceel\",\"appName\":\"default\",\"appId\":\"1\",\"appLayerId\":\"lyr:snapshot-geoserver:postgis:kadastraal_perceel\",\"totalCount\":\"1824\",\"appLayerTitle\":null}\n]}\n"))})
    public ResponseEntity<?> getApplicationLayersGraphicData(@PathVariable Long applicationId, @RequestParam(defaultValue="30") int numberOfDays) {
        if (applicationId == null || applicationId <= 0L || numberOfDays < 1) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid application id or number of days provided.");
        }
        if (!this.prometheusService.isPrometheusAvailable()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Prometheus is not available.");
        }
        String completeQuery = "label_replace(" + this.appLayersSwitchedOnTotalsQuery.replace("#APP_ID#", applicationId.toString()).replace("#NUMBER_OF_DAYS#", String.valueOf(numberOfDays)) + ", \"type\", \"totalCount\", \"__name__\", \".*\") or label_replace(" + this.appLayersSwitchedOnLastUpdatedQuery.replace("#APP_ID#", applicationId.toString()).replace("#NUMBER_OF_DAYS#", String.valueOf(numberOfDays)) + ", \"type\", \"lastUpdateSecondsAgo\", \"__name__\", \".*\")";
        logger.trace("Fetching application layers graph data for applicationId: {} with query: {}", (Object)applicationId, (Object)completeQuery);
        try {
            JsonNode results = this.prometheusService.executeQuery(completeQuery);
            logger.trace("Application layers graph data fetched successfully. {}", (Object)results.toPrettyString());
            Collection data = this.prometheusResultProcessor.processPrometheusResultsForApplicationLayers(results);
            if (!data.isEmpty()) {
                this.applicationRepository.findById(applicationId).ifPresent(application -> data.forEach(metric -> {
                    String appLayerId = (String)metric.get("appLayerId");
                    if (appLayerId != null && !appLayerId.isEmpty()) {
                        application.getAllAppTreeLayerNode().filter(node -> appLayerId.equals(node.getId())).findFirst().ifPresent(node -> {
                            metric.put("appLayerName", node.getLayerName());
                            metric.put("appLayerTitle", application.getAppLayerSettings(node).getTitle());
                        });
                    }
                }));
            }
            return ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().set("applicationLayers", new ObjectMapper().valueToTree((Object)data)));
        }
        catch (IOException e) {
            logger.error("Error fetching application layers graph data", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

