/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.json.JDBCConnectionProperties;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.persistence.json.TMServiceCaps;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Entity
@Table(name="feature_source")
@EntityListeners(value={EntityEventPublisher.class})
@EnhancementInfo(version="6.6.29.Final")
public class TMFeatureSource
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    Long id;
    @Version
    Long version;
    @Transient
    private boolean refreshCapabilities;
    @Column(columnDefinition="text")
    String notes;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    Protocol protocol;
    @Basic
    String title;
    @Column(length=2048)
    String url;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    JDBCConnectionProperties jdbcConnection;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    ServiceAuthentication authentication;
    @ManyToOne
    @JoinColumn(name="linked_service")
    GeoService linkedService;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    TMServiceCaps serviceCapabilities;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="feature_source_feature_types", inverseJoinColumns={@JoinColumn(name="feature_type")}, joinColumns={@JoinColumn(name="feature_source", referencedColumnName="id")})
    @OrderBy(value="name asc")
    List<TMFeatureType> featureTypes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public TMFeatureSource() {
        this.$$_hibernate_write_featureTypes(new ArrayList());
    }

    public String toString() {
        try {
            return "TMFeatureSource{id=" + this.$$_hibernate_read_id() + ", protocol=" + String.valueOf(this.$$_hibernate_read_protocol()) + ", title='" + this.$$_hibernate_read_title() + "', url='" + this.$$_hibernate_read_url() + "', jdbcConnection=" + new ObjectMapper().writeValueAsString((Object)this.$$_hibernate_read_jdbcConnection()) + "}";
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public TMFeatureSource setId(Long id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public TMFeatureSource setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public boolean isRefreshCapabilities() {
        return this.refreshCapabilities;
    }

    public void setRefreshCapabilities(boolean refreshCapabilities) {
        this.refreshCapabilities = refreshCapabilities;
    }

    public String getNotes() {
        return this.$$_hibernate_read_notes();
    }

    public TMFeatureSource setNotes(String notes) {
        this.$$_hibernate_write_notes(notes);
        return this;
    }

    public Protocol getProtocol() {
        return this.$$_hibernate_read_protocol();
    }

    public TMFeatureSource setProtocol(Protocol protocol) {
        this.$$_hibernate_write_protocol(protocol);
        return this;
    }

    public String getTitle() {
        return this.$$_hibernate_read_title();
    }

    public TMFeatureSource setTitle(String title) {
        this.$$_hibernate_write_title(title);
        return this;
    }

    public String getUrl() {
        return this.$$_hibernate_read_url();
    }

    public TMFeatureSource setUrl(String url) {
        this.$$_hibernate_write_url(url);
        return this;
    }

    public JDBCConnectionProperties getJdbcConnection() {
        return this.$$_hibernate_read_jdbcConnection();
    }

    public TMFeatureSource setJdbcConnection(JDBCConnectionProperties jdbcConnection) {
        this.$$_hibernate_write_jdbcConnection(jdbcConnection);
        return this;
    }

    public ServiceAuthentication getAuthentication() {
        return this.$$_hibernate_read_authentication();
    }

    public TMFeatureSource setAuthentication(ServiceAuthentication authentication) {
        this.$$_hibernate_write_authentication(authentication);
        return this;
    }

    public GeoService getLinkedService() {
        return this.$$_hibernate_read_linkedService();
    }

    public TMFeatureSource setLinkedService(GeoService linkedService) {
        this.$$_hibernate_write_linkedService(linkedService);
        return this;
    }

    public TMServiceCaps getServiceCapabilities() {
        return this.$$_hibernate_read_serviceCapabilities();
    }

    public TMFeatureSource setServiceCapabilities(TMServiceCaps serviceCapabilities) {
        this.$$_hibernate_write_serviceCapabilities(serviceCapabilities);
        return this;
    }

    public List<TMFeatureType> getAllFeatureTypes() {
        return this.$$_hibernate_read_featureTypes();
    }

    public List<TMFeatureType> getFeatureTypes() {
        return this.$$_hibernate_read_featureTypes();
    }

    public TMFeatureSource setFeatureTypes(List<TMFeatureType> featureTypes) {
        this.$$_hibernate_write_featureTypes(featureTypes);
        return this;
    }

    public TMFeatureType findFeatureTypeByName(String featureTypeName) {
        return this.getFeatureTypes().stream().filter(ft -> featureTypeName.equals(ft.getName())).findFirst().orElse(null);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        TMFeatureSource tMFeatureSource = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        boolean bl;
        block0: {
            int n;
            block1: {
                TMFeatureSource tMFeatureSource = this;
                bl = false;
                if (bl || this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("featureTypes");
                if (this.featureTypes != null || n == -1) break block1;
                bl = true;
                break block0;
            }
            if (this.featureTypes == null || this.featureTypes instanceof PersistentCollection && !((PersistentCollection)this.featureTypes).wasInitialized() || n == this.featureTypes.size()) break block0;
            bl = true;
        }
        return bl;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block0: {
            int n;
            block1: {
                TMFeatureSource tMFeatureSource = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                if (this.$$_hibernate_collectionTracker == null) break block0;
                n = this.$$_hibernate_collectionTracker.getSize("featureTypes");
                if (this.featureTypes != null || n == -1) break block1;
                dirtyTracker.add("featureTypes");
                break block0;
            }
            if (this.featureTypes == null || this.featureTypes instanceof PersistentCollection && !((PersistentCollection)this.featureTypes).wasInitialized() || n == this.featureTypes.size()) break block0;
            dirtyTracker.add("featureTypes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block3: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            TMFeatureSource tMFeatureSource = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("featureTypes")) break block3;
            if (this.featureTypes == null || this.featureTypes instanceof PersistentCollection && !((PersistentCollection)this.featureTypes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("featureTypes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("featureTypes", this.featureTypes.size());
            }
        }
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public String $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", (Object)this.notes);
        }
        return this.notes;
    }

    public void $$_hibernate_write_notes(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notes", (Object)string, (Object)this.notes)) {
            this.$$_hibernate_trackChange("notes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notes", (Object)this.notes, (Object)string);
            return;
        }
        this.notes = string;
    }

    public Protocol $$_hibernate_read_protocol() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (Protocol)this.$$_hibernate_getInterceptor().readObject((Object)this, "protocol", (Object)this.protocol);
        }
        return this.protocol;
    }

    public void $$_hibernate_write_protocol(Protocol protocol) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"protocol", (Object)protocol, (Object)this.protocol)) {
            this.$$_hibernate_trackChange("protocol");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (Protocol)this.$$_hibernate_getInterceptor().writeObject((Object)this, "protocol", (Object)this.protocol, (Object)protocol);
            return;
        }
        this.protocol = protocol;
    }

    public String $$_hibernate_read_title() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "title", (Object)this.title);
        }
        return this.title;
    }

    public void $$_hibernate_write_title(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"title", (Object)string, (Object)this.title)) {
            this.$$_hibernate_trackChange("title");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "title", (Object)this.title, (Object)string);
            return;
        }
        this.title = string;
    }

    public String $$_hibernate_read_url() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.url = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "url", (Object)this.url);
        }
        return this.url;
    }

    public void $$_hibernate_write_url(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"url", (Object)string, (Object)this.url)) {
            this.$$_hibernate_trackChange("url");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.url = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "url", (Object)this.url, (Object)string);
            return;
        }
        this.url = string;
    }

    public JDBCConnectionProperties $$_hibernate_read_jdbcConnection() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.jdbcConnection = (JDBCConnectionProperties)this.$$_hibernate_getInterceptor().readObject((Object)this, "jdbcConnection", (Object)this.jdbcConnection);
        }
        return this.jdbcConnection;
    }

    public void $$_hibernate_write_jdbcConnection(JDBCConnectionProperties jDBCConnectionProperties) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"jdbcConnection", (Object)jDBCConnectionProperties, (Object)this.jdbcConnection)) {
            this.$$_hibernate_trackChange("jdbcConnection");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.jdbcConnection = (JDBCConnectionProperties)this.$$_hibernate_getInterceptor().writeObject((Object)this, "jdbcConnection", (Object)this.jdbcConnection, (Object)jDBCConnectionProperties);
            return;
        }
        this.jdbcConnection = jDBCConnectionProperties;
    }

    public ServiceAuthentication $$_hibernate_read_authentication() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authentication = (ServiceAuthentication)this.$$_hibernate_getInterceptor().readObject((Object)this, "authentication", (Object)this.authentication);
        }
        return this.authentication;
    }

    public void $$_hibernate_write_authentication(ServiceAuthentication serviceAuthentication) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"authentication", (Object)serviceAuthentication, (Object)this.authentication)) {
            this.$$_hibernate_trackChange("authentication");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authentication = (ServiceAuthentication)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authentication", (Object)this.authentication, (Object)serviceAuthentication);
            return;
        }
        this.authentication = serviceAuthentication;
    }

    public GeoService $$_hibernate_read_linkedService() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.linkedService = (GeoService)this.$$_hibernate_getInterceptor().readObject((Object)this, "linkedService", (Object)this.linkedService);
        }
        return this.linkedService;
    }

    public void $$_hibernate_write_linkedService(GeoService geoService) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"linkedService", (Object)geoService, (Object)this.linkedService)) {
            this.$$_hibernate_trackChange("linkedService");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.linkedService = (GeoService)this.$$_hibernate_getInterceptor().writeObject((Object)this, "linkedService", (Object)this.linkedService, (Object)geoService);
            return;
        }
        this.linkedService = geoService;
    }

    public TMServiceCaps $$_hibernate_read_serviceCapabilities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceCapabilities = (TMServiceCaps)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceCapabilities", (Object)this.serviceCapabilities);
        }
        return this.serviceCapabilities;
    }

    public void $$_hibernate_write_serviceCapabilities(TMServiceCaps tMServiceCaps) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceCapabilities", (Object)tMServiceCaps, (Object)this.serviceCapabilities)) {
            this.$$_hibernate_trackChange("serviceCapabilities");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceCapabilities = (TMServiceCaps)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceCapabilities", (Object)this.serviceCapabilities, (Object)tMServiceCaps);
            return;
        }
        this.serviceCapabilities = tMServiceCaps;
    }

    public List $$_hibernate_read_featureTypes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.featureTypes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "featureTypes", (Object)this.featureTypes);
        }
        return this.featureTypes;
    }

    public void $$_hibernate_write_featureTypes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.featureTypes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "featureTypes", (Object)this.featureTypes, (Object)list);
            return;
        }
        this.featureTypes = list;
    }
}

