/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import jakarta.servlet.Filter;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.transaction.annotation.Transactional;
import org.tailormap.api.persistence.Group;
import org.tailormap.api.persistence.User;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.repository.UserRepository;
import org.tailormap.api.security.AuditInterceptor;
import org.tailormap.api.security.InternalAdminAuthentication;

@Configuration
@Order(value=1)
public class ActuatorSecurityConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${management.endpoints.web.base-path}")
    private String basePath;
    @Value(value="${tailormap-api.management.hashed-password}")
    private String hashedPassword;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;

    public ActuatorSecurityConfiguration(UserRepository userRepository, GroupRepository groupRepository) {
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    @DependsOn(value={"tailormap-database-initialization"})
    public void createActuatorAccount() {
        if (StringUtils.isBlank((CharSequence)this.hashedPassword)) {
            return;
        }
        InternalAdminAuthentication.setInSecurityContext();
        try {
            User account = this.userRepository.findById("actuator").orElse(null);
            if (account != null) {
                String msg = this.hashedPassword.equals(account.getPassword()) ? "with the hashed password in" : "with a different password from";
                logger.info("Actuator account already exists {} the MANAGEMENT_HASHED_ACCOUNT environment variable", (Object)msg);
            } else if (!this.hashedPassword.startsWith("{bcrypt}")) {
                logger.error("Invalid password hash, must start with {bcrypt}");
            } else {
                account = new User().setUsername("actuator").setPassword(this.hashedPassword);
                account.getGroups().add((Group)this.groupRepository.findById((Object)"actuator").orElseThrow());
                this.userRepository.save((Object)account);
                logger.info("Created {} account with hashed password for management", (Object)"actuator");
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
    }

    @Bean
    public SecurityFilterChain actuatorFilterChain(HttpSecurity http, CookieCsrfTokenRepository csrfTokenRepository) throws Exception {
        http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository)).securityMatcher(new String[]{this.basePath + "/**"}).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{this.basePath + "/health/**"})).permitAll().requestMatchers(new String[]{this.basePath + "/info"})).permitAll().requestMatchers(new String[]{this.basePath + "/**"})).access((authentication, context) -> {
            String remoteAddr = context.getRequest().getRemoteAddr();
            if (remoteAddr.startsWith("10.") || remoteAddr.startsWith("192.168.") || remoteAddr.startsWith("172.") || remoteAddr.startsWith("127.")) {
                return new AuthorizationDecision(true);
            }
            if (authentication.get() == null) {
                return new AuthorizationDecision(false);
            }
            return new AuthorizationDecision(((Authentication)authentication.get()).getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("admin") || a.getAuthority().equals("actuator")));
        })).httpBasic(Customizer.withDefaults()).addFilterAfter((Filter)new AuditInterceptor(), AnonymousAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }
}

