package org.tailormap.api.admin.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.UUID;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TaskSchedule
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class TaskSchedule implements Serializable {

  private static final long serialVersionUID = 1L;

  private UUID uuid = null;

  private String description = null;

  private String cronExpression;

  private Integer priority = null;

  public TaskSchedule() {
    super();
  }

  public TaskSchedule uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * UUID of the task; this is the unique identifier of the task
   * @return uuid
   */
  @Valid 
  @Schema(name = "uuid", accessMode = Schema.AccessMode.READ_ONLY, description = "UUID of the task; this is the unique identifier of the task", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("uuid")
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public TaskSchedule description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Human-readable description of the task.
   * @return description
   */
  
  @Schema(name = "description", description = "Human-readable description of the task.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TaskSchedule cronExpression(String cronExpression) {
    this.cronExpression = cronExpression;
    return this;
  }

  /**
   * Cron expression for the task
   * @return cronExpression
   */
  @NotNull 
  @Schema(name = "cronExpression", description = "Cron expression for the task", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("cronExpression")
  public String getCronExpression() {
    return cronExpression;
  }

  public void setCronExpression(String cronExpression) {
    this.cronExpression = cronExpression;
  }

  public TaskSchedule priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Priority of the task
   * @return priority
   */
  
  @Schema(name = "priority", description = "Priority of the task", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("priority")
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskSchedule taskSchedule = (TaskSchedule) o;
    return Objects.equals(this.uuid, taskSchedule.uuid) &&
        Objects.equals(this.description, taskSchedule.description) &&
        Objects.equals(this.cronExpression, taskSchedule.cronExpression) &&
        Objects.equals(this.priority, taskSchedule.priority);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, description, cronExpression, priority);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskSchedule {\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    cronExpression: ").append(toIndentedString(cronExpression)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

