package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Configuration for a date filter
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "DatePickerFilterConfiguration", description = "Configuration for a date filter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class DatePickerFilterConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialLowerDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialUpperDate;

  public DatePickerFilterConfiguration initialDate(OffsetDateTime initialDate) {
    this.initialDate = initialDate;
    return this;
  }

  /**
   * initial value for the date filter
   * @return initialDate
   */
  @Valid 
  @Schema(name = "initialDate", description = "initial value for the date filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialDate")
  public OffsetDateTime getInitialDate() {
    return initialDate;
  }

  public void setInitialDate(OffsetDateTime initialDate) {
    this.initialDate = initialDate;
  }

  public DatePickerFilterConfiguration initialLowerDate(OffsetDateTime initialLowerDate) {
    this.initialLowerDate = initialLowerDate;
    return this;
  }

  /**
   * initial lower value for a date filter with between condition
   * @return initialLowerDate
   */
  @Valid 
  @Schema(name = "initialLowerDate", description = "initial lower value for a date filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialLowerDate")
  public OffsetDateTime getInitialLowerDate() {
    return initialLowerDate;
  }

  public void setInitialLowerDate(OffsetDateTime initialLowerDate) {
    this.initialLowerDate = initialLowerDate;
  }

  public DatePickerFilterConfiguration initialUpperDate(OffsetDateTime initialUpperDate) {
    this.initialUpperDate = initialUpperDate;
    return this;
  }

  /**
   * initial upper value for a date filter with between condition
   * @return initialUpperDate
   */
  @Valid 
  @Schema(name = "initialUpperDate", description = "initial upper value for a date filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialUpperDate")
  public OffsetDateTime getInitialUpperDate() {
    return initialUpperDate;
  }

  public void setInitialUpperDate(OffsetDateTime initialUpperDate) {
    this.initialUpperDate = initialUpperDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DatePickerFilterConfiguration datePickerFilterConfiguration = (DatePickerFilterConfiguration) o;
    return Objects.equals(this.initialDate, datePickerFilterConfiguration.initialDate) &&
        Objects.equals(this.initialLowerDate, datePickerFilterConfiguration.initialLowerDate) &&
        Objects.equals(this.initialUpperDate, datePickerFilterConfiguration.initialUpperDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(initialDate, initialLowerDate, initialUpperDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DatePickerFilterConfiguration {\n");
    sb.append("    initialDate: ").append(toIndentedString(initialDate)).append("\n");
    sb.append("    initialLowerDate: ").append(toIndentedString(initialLowerDate)).append("\n");
    sb.append("    initialUpperDate: ").append(toIndentedString(initialUpperDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

