package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AttributeValueSettings;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * configuration for editing filter
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "Filter_editConfiguration", description = "configuration for editing filter")
@JsonTypeName("Filter_editConfiguration")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class FilterEditConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * the type of filter tool
   */
  public enum FilterToolEnum {
    SLIDER("SLIDER"),
    
    CHECKBOX("CHECKBOX"),
    
    SWITCH("SWITCH"),
    
    DATE_PICKER("DATE_PICKER"),
    
    DROPDOWN_LIST("DROPDOWN_LIST");

    private final String value;

    FilterToolEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterToolEnum fromValue(String value) {
      for (FilterToolEnum b : FilterToolEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private FilterToolEnum filterTool;

  private Double minimumValue;

  private Double maximumValue;

  private Double initialValue;

  private Double initialLowerValue;

  private Double initialUpperValue;

  /**
   * the mode of input for the filter
   */
  public enum InputModeEnum {
    SLIDER("SLIDER"),
    
    INPUT_FIELD("INPUT_FIELD"),
    
    SLIDER_AND_INPUT_FIELD("SLIDER_AND_INPUT_FIELD");

    private final String value;

    InputModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InputModeEnum fromValue(String value) {
      for (InputModeEnum b : InputModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private InputModeEnum inputMode = InputModeEnum.SLIDER;

  private Double stepSize;

  @Valid
  private List<@Valid AttributeValueSettings> attributeValuesSettings = new ArrayList<>();

  private String value1;

  private String value2;

  private String alias1;

  private String alias2;

  private Boolean startWithValue2 = false;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialLowerDate;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime initialUpperDate;

  public FilterEditConfiguration filterTool(FilterToolEnum filterTool) {
    this.filterTool = filterTool;
    return this;
  }

  /**
   * the type of filter tool
   * @return filterTool
   */
  
  @Schema(name = "filterTool", description = "the type of filter tool", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filterTool")
  public FilterToolEnum getFilterTool() {
    return filterTool;
  }

  public void setFilterTool(FilterToolEnum filterTool) {
    this.filterTool = filterTool;
  }

  public FilterEditConfiguration minimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
    return this;
  }

  /**
   * minimum value for the slider
   * @return minimumValue
   */
  
  @Schema(name = "minimumValue", description = "minimum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minimumValue")
  public Double getMinimumValue() {
    return minimumValue;
  }

  public void setMinimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
  }

  public FilterEditConfiguration maximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
    return this;
  }

  /**
   * maximum value for the slider
   * @return maximumValue
   */
  
  @Schema(name = "maximumValue", description = "maximum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maximumValue")
  public Double getMaximumValue() {
    return maximumValue;
  }

  public void setMaximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
  }

  public FilterEditConfiguration initialValue(Double initialValue) {
    this.initialValue = initialValue;
    return this;
  }

  /**
   * initial value for the slider
   * @return initialValue
   */
  
  @Schema(name = "initialValue", description = "initial value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialValue")
  public Double getInitialValue() {
    return initialValue;
  }

  public void setInitialValue(Double initialValue) {
    this.initialValue = initialValue;
  }

  public FilterEditConfiguration initialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
    return this;
  }

  /**
   * initial lower value for a slider filter with between condition
   * @return initialLowerValue
   */
  
  @Schema(name = "initialLowerValue", description = "initial lower value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialLowerValue")
  public Double getInitialLowerValue() {
    return initialLowerValue;
  }

  public void setInitialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
  }

  public FilterEditConfiguration initialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
    return this;
  }

  /**
   * initial upper value for a slider filter with between condition
   * @return initialUpperValue
   */
  
  @Schema(name = "initialUpperValue", description = "initial upper value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialUpperValue")
  public Double getInitialUpperValue() {
    return initialUpperValue;
  }

  public void setInitialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
  }

  public FilterEditConfiguration inputMode(InputModeEnum inputMode) {
    this.inputMode = inputMode;
    return this;
  }

  /**
   * the mode of input for the filter
   * @return inputMode
   */
  
  @Schema(name = "inputMode", description = "the mode of input for the filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputMode")
  public InputModeEnum getInputMode() {
    return inputMode;
  }

  public void setInputMode(InputModeEnum inputMode) {
    this.inputMode = inputMode;
  }

  public FilterEditConfiguration stepSize(Double stepSize) {
    this.stepSize = stepSize;
    return this;
  }

  /**
   * the step size for the slider
   * @return stepSize
   */
  
  @Schema(name = "stepSize", description = "the step size for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("stepSize")
  public Double getStepSize() {
    return stepSize;
  }

  public void setStepSize(Double stepSize) {
    this.stepSize = stepSize;
  }

  public FilterEditConfiguration attributeValuesSettings(List<@Valid AttributeValueSettings> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
    return this;
  }

  public FilterEditConfiguration addAttributeValuesSettingsItem(AttributeValueSettings attributeValuesSettingsItem) {
    if (this.attributeValuesSettings == null) {
      this.attributeValuesSettings = new ArrayList<>();
    }
    this.attributeValuesSettings.add(attributeValuesSettingsItem);
    return this;
  }

  /**
   * settings for the attribute values
   * @return attributeValuesSettings
   */
  @Valid 
  @Schema(name = "attributeValuesSettings", description = "settings for the attribute values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributeValuesSettings")
  public List<@Valid AttributeValueSettings> getAttributeValuesSettings() {
    return attributeValuesSettings;
  }

  public void setAttributeValuesSettings(List<@Valid AttributeValueSettings> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
  }

  public FilterEditConfiguration value1(String value1) {
    this.value1 = value1;
    return this;
  }

  /**
   * Get value1
   * @return value1
   */
  
  @Schema(name = "value1", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value1")
  public String getValue1() {
    return value1;
  }

  public void setValue1(String value1) {
    this.value1 = value1;
  }

  public FilterEditConfiguration value2(String value2) {
    this.value2 = value2;
    return this;
  }

  /**
   * Get value2
   * @return value2
   */
  
  @Schema(name = "value2", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value2")
  public String getValue2() {
    return value2;
  }

  public void setValue2(String value2) {
    this.value2 = value2;
  }

  public FilterEditConfiguration alias1(String alias1) {
    this.alias1 = alias1;
    return this;
  }

  /**
   * Get alias1
   * @return alias1
   */
  
  @Schema(name = "alias1", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias1")
  public String getAlias1() {
    return alias1;
  }

  public void setAlias1(String alias1) {
    this.alias1 = alias1;
  }

  public FilterEditConfiguration alias2(String alias2) {
    this.alias2 = alias2;
    return this;
  }

  /**
   * Get alias2
   * @return alias2
   */
  
  @Schema(name = "alias2", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias2")
  public String getAlias2() {
    return alias2;
  }

  public void setAlias2(String alias2) {
    this.alias2 = alias2;
  }

  public FilterEditConfiguration startWithValue2(Boolean startWithValue2) {
    this.startWithValue2 = startWithValue2;
    return this;
  }

  /**
   * when true the filter starts with value2 selected
   * @return startWithValue2
   */
  
  @Schema(name = "startWithValue2", description = "when true the filter starts with value2 selected", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startWithValue2")
  public Boolean getStartWithValue2() {
    return startWithValue2;
  }

  public void setStartWithValue2(Boolean startWithValue2) {
    this.startWithValue2 = startWithValue2;
  }

  public FilterEditConfiguration initialDate(OffsetDateTime initialDate) {
    this.initialDate = initialDate;
    return this;
  }

  /**
   * initial value for the date filter
   * @return initialDate
   */
  @Valid 
  @Schema(name = "initialDate", description = "initial value for the date filter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialDate")
  public OffsetDateTime getInitialDate() {
    return initialDate;
  }

  public void setInitialDate(OffsetDateTime initialDate) {
    this.initialDate = initialDate;
  }

  public FilterEditConfiguration initialLowerDate(OffsetDateTime initialLowerDate) {
    this.initialLowerDate = initialLowerDate;
    return this;
  }

  /**
   * initial lower value for a date filter with between condition
   * @return initialLowerDate
   */
  @Valid 
  @Schema(name = "initialLowerDate", description = "initial lower value for a date filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialLowerDate")
  public OffsetDateTime getInitialLowerDate() {
    return initialLowerDate;
  }

  public void setInitialLowerDate(OffsetDateTime initialLowerDate) {
    this.initialLowerDate = initialLowerDate;
  }

  public FilterEditConfiguration initialUpperDate(OffsetDateTime initialUpperDate) {
    this.initialUpperDate = initialUpperDate;
    return this;
  }

  /**
   * initial upper value for a date filter with between condition
   * @return initialUpperDate
   */
  @Valid 
  @Schema(name = "initialUpperDate", description = "initial upper value for a date filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialUpperDate")
  public OffsetDateTime getInitialUpperDate() {
    return initialUpperDate;
  }

  public void setInitialUpperDate(OffsetDateTime initialUpperDate) {
    this.initialUpperDate = initialUpperDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterEditConfiguration filterEditConfiguration = (FilterEditConfiguration) o;
    return Objects.equals(this.filterTool, filterEditConfiguration.filterTool) &&
        Objects.equals(this.minimumValue, filterEditConfiguration.minimumValue) &&
        Objects.equals(this.maximumValue, filterEditConfiguration.maximumValue) &&
        Objects.equals(this.initialValue, filterEditConfiguration.initialValue) &&
        Objects.equals(this.initialLowerValue, filterEditConfiguration.initialLowerValue) &&
        Objects.equals(this.initialUpperValue, filterEditConfiguration.initialUpperValue) &&
        Objects.equals(this.inputMode, filterEditConfiguration.inputMode) &&
        Objects.equals(this.stepSize, filterEditConfiguration.stepSize) &&
        Objects.equals(this.attributeValuesSettings, filterEditConfiguration.attributeValuesSettings) &&
        Objects.equals(this.value1, filterEditConfiguration.value1) &&
        Objects.equals(this.value2, filterEditConfiguration.value2) &&
        Objects.equals(this.alias1, filterEditConfiguration.alias1) &&
        Objects.equals(this.alias2, filterEditConfiguration.alias2) &&
        Objects.equals(this.startWithValue2, filterEditConfiguration.startWithValue2) &&
        Objects.equals(this.initialDate, filterEditConfiguration.initialDate) &&
        Objects.equals(this.initialLowerDate, filterEditConfiguration.initialLowerDate) &&
        Objects.equals(this.initialUpperDate, filterEditConfiguration.initialUpperDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filterTool, minimumValue, maximumValue, initialValue, initialLowerValue, initialUpperValue, inputMode, stepSize, attributeValuesSettings, value1, value2, alias1, alias2, startWithValue2, initialDate, initialLowerDate, initialUpperDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterEditConfiguration {\n");
    sb.append("    filterTool: ").append(toIndentedString(filterTool)).append("\n");
    sb.append("    minimumValue: ").append(toIndentedString(minimumValue)).append("\n");
    sb.append("    maximumValue: ").append(toIndentedString(maximumValue)).append("\n");
    sb.append("    initialValue: ").append(toIndentedString(initialValue)).append("\n");
    sb.append("    initialLowerValue: ").append(toIndentedString(initialLowerValue)).append("\n");
    sb.append("    initialUpperValue: ").append(toIndentedString(initialUpperValue)).append("\n");
    sb.append("    inputMode: ").append(toIndentedString(inputMode)).append("\n");
    sb.append("    stepSize: ").append(toIndentedString(stepSize)).append("\n");
    sb.append("    attributeValuesSettings: ").append(toIndentedString(attributeValuesSettings)).append("\n");
    sb.append("    value1: ").append(toIndentedString(value1)).append("\n");
    sb.append("    value2: ").append(toIndentedString(value2)).append("\n");
    sb.append("    alias1: ").append(toIndentedString(alias1)).append("\n");
    sb.append("    alias2: ").append(toIndentedString(alias2)).append("\n");
    sb.append("    startWithValue2: ").append(toIndentedString(startWithValue2)).append("\n");
    sb.append("    initialDate: ").append(toIndentedString(initialDate)).append("\n");
    sb.append("    initialLowerDate: ").append(toIndentedString(initialLowerDate)).append("\n");
    sb.append("    initialUpperDate: ").append(toIndentedString(initialUpperDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

