package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model for a menu items
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "MenuItem", description = "model for a menu items")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class MenuItem implements Serializable {

  private static final long serialVersionUID = 1L;

  private String label;

  private String pageUrl = null;

  private String url = null;

  private Boolean openInNewWindow = null;

  private Long pageId;

  private Long exclusiveOnPageId;

  public MenuItem label(String label) {
    this.label = label;
    return this;
  }

  /**
   * menu item label
   * @return label
   */
  
  @Schema(name = "label", description = "menu item label", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public MenuItem pageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
    return this;
  }

  /**
   * link to another page
   * @return pageUrl
   */
  
  @Schema(name = "pageUrl", description = "link to another page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageUrl")
  public String getPageUrl() {
    return pageUrl;
  }

  public void setPageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
  }

  public MenuItem url(String url) {
    this.url = url;
    return this;
  }

  /**
   * link to an other domain / website
   * @return url
   */
  
  @Schema(name = "url", description = "link to an other domain / website", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public MenuItem openInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
    return this;
  }

  /**
   * indicates whether the link should be opened in a new window
   * @return openInNewWindow
   */
  
  @Schema(name = "openInNewWindow", description = "indicates whether the link should be opened in a new window", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("openInNewWindow")
  public Boolean getOpenInNewWindow() {
    return openInNewWindow;
  }

  public void setOpenInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
  }

  public MenuItem pageId(Long pageId) {
    this.pageId = pageId;
    return this;
  }

  /**
   * Get pageId
   * @return pageId
   */
  
  @Schema(name = "pageId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageId")
  public Long getPageId() {
    return pageId;
  }

  public void setPageId(Long pageId) {
    this.pageId = pageId;
  }

  public MenuItem exclusiveOnPageId(Long exclusiveOnPageId) {
    this.exclusiveOnPageId = exclusiveOnPageId;
    return this;
  }

  /**
   * Get exclusiveOnPageId
   * @return exclusiveOnPageId
   */
  
  @Schema(name = "exclusiveOnPageId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("exclusiveOnPageId")
  public Long getExclusiveOnPageId() {
    return exclusiveOnPageId;
  }

  public void setExclusiveOnPageId(Long exclusiveOnPageId) {
    this.exclusiveOnPageId = exclusiveOnPageId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MenuItem menuItem = (MenuItem) o;
    return Objects.equals(this.label, menuItem.label) &&
        Objects.equals(this.pageUrl, menuItem.pageUrl) &&
        Objects.equals(this.url, menuItem.url) &&
        Objects.equals(this.openInNewWindow, menuItem.openInNewWindow) &&
        Objects.equals(this.pageId, menuItem.pageId) &&
        Objects.equals(this.exclusiveOnPageId, menuItem.exclusiveOnPageId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(label, pageUrl, url, openInNewWindow, pageId, exclusiveOnPageId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MenuItem {\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    pageUrl: ").append(toIndentedString(pageUrl)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    openInNewWindow: ").append(toIndentedString(openInNewWindow)).append("\n");
    sb.append("    pageId: ").append(toIndentedString(pageId)).append("\n");
    sb.append("    exclusiveOnPageId: ").append(toIndentedString(exclusiveOnPageId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

