package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Settings applying to a XYZ layer.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "XYZLayerSettings", description = "Settings applying to a XYZ layer.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class XYZLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Boolean hiDpiDisabled = null;

  private FeatureTypeRef featureType;

  private String attribution = null;

  private String description = null;

  private String legendImageId = null;

  @Valid
  private List<@Valid AuthorizationRule> authorizationRules = new ArrayList<>();

  private Integer minZoom = null;

  private Integer maxZoom = null;

  private Integer tileSize = null;

  private Bounds tileGridExtent;

  private TileLayerHiDpiMode hiDpiMode;

  private String hiDpiSubstituteLayer = null;

  public XYZLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Override default title, null if not overridden.
   * @return title
   */
  
  @Schema(name = "title", description = "Override default title, null if not overridden.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public XYZLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
    return this;
  }

  /**
   * Get hiDpiDisabled
   * @return hiDpiDisabled
   */
  
  @Schema(name = "hiDpiDisabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiDisabled")
  public Boolean getHiDpiDisabled() {
    return hiDpiDisabled;
  }

  public void setHiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
  }

  public XYZLayerSettings featureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
    return this;
  }

  /**
   * Get featureType
   * @return featureType
   */
  @Valid 
  @Schema(name = "featureType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureType")
  public FeatureTypeRef getFeatureType() {
    return featureType;
  }

  public void setFeatureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
  }

  public XYZLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
   */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public XYZLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
   */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public XYZLayerSettings legendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
    return this;
  }

  /**
   * ID of uploaded legend image
   * @return legendImageId
   */
  
  @Schema(name = "legendImageId", description = "ID of uploaded legend image", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendImageId")
  public String getLegendImageId() {
    return legendImageId;
  }

  public void setLegendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
  }

  public XYZLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
    return this;
  }

  public XYZLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
    if (this.authorizationRules == null) {
      this.authorizationRules = new ArrayList<>();
    }
    this.authorizationRules.add(authorizationRulesItem);
    return this;
  }

  /**
   * Get authorizationRules
   * @return authorizationRules
   */
  @Valid 
  @Schema(name = "authorizationRules", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("authorizationRules")
  public List<@Valid AuthorizationRule> getAuthorizationRules() {
    return authorizationRules;
  }

  public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
  }

  public XYZLayerSettings minZoom(Integer minZoom) {
    this.minZoom = minZoom;
    return this;
  }

  /**
   * minZoom property of OpenLayers XYZ source
   * @return minZoom
   */
  
  @Schema(name = "minZoom", description = "minZoom property of OpenLayers XYZ source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minZoom")
  public Integer getMinZoom() {
    return minZoom;
  }

  public void setMinZoom(Integer minZoom) {
    this.minZoom = minZoom;
  }

  public XYZLayerSettings maxZoom(Integer maxZoom) {
    this.maxZoom = maxZoom;
    return this;
  }

  /**
   * maxZoom property of OpenLayers XYZ source
   * @return maxZoom
   */
  
  @Schema(name = "maxZoom", description = "maxZoom property of OpenLayers XYZ source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxZoom")
  public Integer getMaxZoom() {
    return maxZoom;
  }

  public void setMaxZoom(Integer maxZoom) {
    this.maxZoom = maxZoom;
  }

  public XYZLayerSettings tileSize(Integer tileSize) {
    this.tileSize = tileSize;
    return this;
  }

  /**
   * tile size property of OpenLayers XYZ source
   * @return tileSize
   */
  
  @Schema(name = "tileSize", description = "tile size property of OpenLayers XYZ source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tileSize")
  public Integer getTileSize() {
    return tileSize;
  }

  public void setTileSize(Integer tileSize) {
    this.tileSize = tileSize;
  }

  public XYZLayerSettings tileGridExtent(Bounds tileGridExtent) {
    this.tileGridExtent = tileGridExtent;
    return this;
  }

  /**
   * Get tileGridExtent
   * @return tileGridExtent
   */
  @Valid 
  @Schema(name = "tileGridExtent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tileGridExtent")
  public Bounds getTileGridExtent() {
    return tileGridExtent;
  }

  public void setTileGridExtent(Bounds tileGridExtent) {
    this.tileGridExtent = tileGridExtent;
  }

  public XYZLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
    return this;
  }

  /**
   * Get hiDpiMode
   * @return hiDpiMode
   */
  @Valid 
  @Schema(name = "hiDpiMode", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiMode")
  public TileLayerHiDpiMode getHiDpiMode() {
    return hiDpiMode;
  }

  public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
  }

  public XYZLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    return this;
  }

  /**
   * Alternate URL template to use when rendering at high dpi (using 'layer' instead of 'url' in the name for ease of use).
   * @return hiDpiSubstituteLayer
   */
  
  @Schema(name = "hiDpiSubstituteLayer", description = "Alternate URL template to use when rendering at high dpi (using 'layer' instead of 'url' in the name for ease of use).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiSubstituteLayer")
  public String getHiDpiSubstituteLayer() {
    return hiDpiSubstituteLayer;
  }

  public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    XYZLayerSettings xyZLayerSettings = (XYZLayerSettings) o;
    return Objects.equals(this.title, xyZLayerSettings.title) &&
        Objects.equals(this.hiDpiDisabled, xyZLayerSettings.hiDpiDisabled) &&
        Objects.equals(this.featureType, xyZLayerSettings.featureType) &&
        Objects.equals(this.attribution, xyZLayerSettings.attribution) &&
        Objects.equals(this.description, xyZLayerSettings.description) &&
        Objects.equals(this.legendImageId, xyZLayerSettings.legendImageId) &&
        Objects.equals(this.authorizationRules, xyZLayerSettings.authorizationRules) &&
        Objects.equals(this.minZoom, xyZLayerSettings.minZoom) &&
        Objects.equals(this.maxZoom, xyZLayerSettings.maxZoom) &&
        Objects.equals(this.tileSize, xyZLayerSettings.tileSize) &&
        Objects.equals(this.tileGridExtent, xyZLayerSettings.tileGridExtent) &&
        Objects.equals(this.hiDpiMode, xyZLayerSettings.hiDpiMode) &&
        Objects.equals(this.hiDpiSubstituteLayer, xyZLayerSettings.hiDpiSubstituteLayer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, hiDpiDisabled, featureType, attribution, description, legendImageId, authorizationRules, minZoom, maxZoom, tileSize, tileGridExtent, hiDpiMode, hiDpiSubstituteLayer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class XYZLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    hiDpiDisabled: ").append(toIndentedString(hiDpiDisabled)).append("\n");
    sb.append("    featureType: ").append(toIndentedString(featureType)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    legendImageId: ").append(toIndentedString(legendImageId)).append("\n");
    sb.append("    authorizationRules: ").append(toIndentedString(authorizationRules)).append("\n");
    sb.append("    minZoom: ").append(toIndentedString(minZoom)).append("\n");
    sb.append("    maxZoom: ").append(toIndentedString(maxZoom)).append("\n");
    sb.append("    tileSize: ").append(toIndentedString(tileSize)).append("\n");
    sb.append("    tileGridExtent: ").append(toIndentedString(tileGridExtent)).append("\n");
    sb.append("    hiDpiMode: ").append(toIndentedString(hiDpiMode)).append("\n");
    sb.append("    hiDpiSubstituteLayer: ").append(toIndentedString(hiDpiSubstituteLayer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

