package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * AttributeValueSettings
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class AttributeValueSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String value;

  private Boolean initiallySelected = true;

  private Boolean selectable = true;

  private String alias;

  private Boolean useAsIlikeSubstringFilter = false;

  public AttributeValueSettings value(String value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
   */
  
  @Schema(name = "value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value")
  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public AttributeValueSettings initiallySelected(Boolean initiallySelected) {
    this.initiallySelected = initiallySelected;
    return this;
  }

  /**
   * Get initiallySelected
   * @return initiallySelected
   */
  
  @Schema(name = "initiallySelected", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initiallySelected")
  public Boolean getInitiallySelected() {
    return initiallySelected;
  }

  public void setInitiallySelected(Boolean initiallySelected) {
    this.initiallySelected = initiallySelected;
  }

  public AttributeValueSettings selectable(Boolean selectable) {
    this.selectable = selectable;
    return this;
  }

  /**
   * Get selectable
   * @return selectable
   */
  
  @Schema(name = "selectable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("selectable")
  public Boolean getSelectable() {
    return selectable;
  }

  public void setSelectable(Boolean selectable) {
    this.selectable = selectable;
  }

  public AttributeValueSettings alias(String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * Get alias
   * @return alias
   */
  
  @Schema(name = "alias", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias")
  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public AttributeValueSettings useAsIlikeSubstringFilter(Boolean useAsIlikeSubstringFilter) {
    this.useAsIlikeSubstringFilter = useAsIlikeSubstringFilter;
    return this;
  }

  /**
   * Use this value as a separate substring filter using the ILIKE condition
   * @return useAsIlikeSubstringFilter
   */
  
  @Schema(name = "useAsIlikeSubstringFilter", description = "Use this value as a separate substring filter using the ILIKE condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("useAsIlikeSubstringFilter")
  public Boolean getUseAsIlikeSubstringFilter() {
    return useAsIlikeSubstringFilter;
  }

  public void setUseAsIlikeSubstringFilter(Boolean useAsIlikeSubstringFilter) {
    this.useAsIlikeSubstringFilter = useAsIlikeSubstringFilter;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeValueSettings attributeValueSettings = (AttributeValueSettings) o;
    return Objects.equals(this.value, attributeValueSettings.value) &&
        Objects.equals(this.initiallySelected, attributeValueSettings.initiallySelected) &&
        Objects.equals(this.selectable, attributeValueSettings.selectable) &&
        Objects.equals(this.alias, attributeValueSettings.alias) &&
        Objects.equals(this.useAsIlikeSubstringFilter, attributeValueSettings.useAsIlikeSubstringFilter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, initiallySelected, selectable, alias, useAsIlikeSubstringFilter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeValueSettings {\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    initiallySelected: ").append(toIndentedString(initiallySelected)).append("\n");
    sb.append("    selectable: ").append(toIndentedString(selectable)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    useAsIlikeSubstringFilter: ").append(toIndentedString(useAsIlikeSubstringFilter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

