package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Grouping of layers in a tree structure.
 */

@Schema(name = "LayerTreeNode", description = "Grouping of layers in a tree structure.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.16.0")
public class LayerTreeNode implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String appLayerId;

  private Boolean root;

  private String name;

  private String description;

  @Valid
  private List<String> childrenIds = new ArrayList<>();

  public LayerTreeNode() {
    super();
  }

  public LayerTreeNode id(String id) {
    this.id = id;
    return this;
  }

  /**
   * A unique identifier across all tree nodes.
   * @return id
   */
  @NotNull 
  @Schema(name = "id", description = "A unique identifier across all tree nodes.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public LayerTreeNode appLayerId(String appLayerId) {
    this.appLayerId = appLayerId;
    return this;
  }

  /**
   * Get appLayerId
   * @return appLayerId
   */
  
  @Schema(name = "appLayerId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("appLayerId")
  public String getAppLayerId() {
    return appLayerId;
  }

  public void setAppLayerId(String appLayerId) {
    this.appLayerId = appLayerId;
  }

  public LayerTreeNode root(Boolean root) {
    this.root = root;
    return this;
  }

  /**
   * Only a single node in a tree will have this set to true.
   * @return root
   */
  
  @Schema(name = "root", description = "Only a single node in a tree will have this set to true.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("root")
  public Boolean getRoot() {
    return root;
  }

  public void setRoot(Boolean root) {
    this.root = root;
  }

  public LayerTreeNode name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Display name of this tree node. If appLayerId is present, this is the title of that AppLayer.
   * @return name
   */
  @NotNull 
  @Schema(name = "name", description = "Display name of this tree node. If appLayerId is present, this is the title of that AppLayer.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LayerTreeNode description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description for this node entered by application admin.
   * @return description
   */
  
  @Schema(name = "description", description = "Description for this node entered by application admin.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public LayerTreeNode childrenIds(List<String> childrenIds) {
    this.childrenIds = childrenIds;
    return this;
  }

  public LayerTreeNode addChildrenIdsItem(String childrenIdsItem) {
    if (this.childrenIds == null) {
      this.childrenIds = new ArrayList<>();
    }
    this.childrenIds.add(childrenIdsItem);
    return this;
  }

  /**
   * Ordered list of ids of LayerTreeNodes that are children of this node.
   * @return childrenIds
   */
  
  @Schema(name = "childrenIds", description = "Ordered list of ids of LayerTreeNodes that are children of this node.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("childrenIds")
  public List<String> getChildrenIds() {
    return childrenIds;
  }

  public void setChildrenIds(List<String> childrenIds) {
    this.childrenIds = childrenIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LayerTreeNode layerTreeNode = (LayerTreeNode) o;
    return Objects.equals(this.id, layerTreeNode.id) &&
        Objects.equals(this.appLayerId, layerTreeNode.appLayerId) &&
        Objects.equals(this.root, layerTreeNode.root) &&
        Objects.equals(this.name, layerTreeNode.name) &&
        Objects.equals(this.description, layerTreeNode.description) &&
        Objects.equals(this.childrenIds, layerTreeNode.childrenIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, appLayerId, root, name, description, childrenIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LayerTreeNode {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    appLayerId: ").append(toIndentedString(appLayerId)).append("\n");
    sb.append("    root: ").append(toIndentedString(root)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    childrenIds: ").append(toIndentedString(childrenIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

