/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration;

import jakarta.annotation.PostConstruct;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GeoToolsEPSGAliasesConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int[][] EPSG_ALIASES = new int[][]{{900913, 3857}};

    @PostConstruct
    public void addEPSGAliases() throws IOException, FactoryException {
        File f = File.createTempFile("epsg", "properties");
        try (PrintWriter writer = new PrintWriter(f, StandardCharsets.US_ASCII);){
            for (int[] alias : EPSG_ALIASES) {
                writer.printf("%d=%s\n", alias[0], ((Formattable)CRS.decode((String)("EPSG:" + alias[1]))).toWKT(0));
            }
        }
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, PropertyAuthorityFactory.class);
        ReferencingFactoryContainer referencingFactoryContainer = ReferencingFactoryContainer.instance((Hints)hints);
        PropertyAuthorityFactory factory = new PropertyAuthorityFactory(referencingFactoryContainer, Citations.fromName((String)"EPSG"), f.toURI().toURL());
        ReferencingFactoryFinder.addAuthorityFactory((AuthorityFactory)factory);
        ReferencingFactoryFinder.scanForPlugins();
        for (int[] alias : EPSG_ALIASES) {
            logger.info("Added CRS alias to GeoTools: EPSG:{} -> EPSG:{}", (Object)alias[0], (Object)alias[1]);
        }
    }
}

