/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.NotNull;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tailormap.api.persistence.json.AppContent;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.listener.EntityEventPublisher;
import org.tailormap.api.viewer.model.AppStyling;
import org.tailormap.api.viewer.model.Component;

@Entity
@EntityListeners(value={EntityEventPublisher.class})
@EnhancementInfo(version="6.6.29.Final")
public class Application
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker,
CompositeOwner {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    Long id;
    @Version
    Long version;
    @Column(unique=true)
    @NotNull
    String name;
    String title;
    @Column(columnDefinition="text")
    String adminComments;
    @Column(columnDefinition="text")
    String previewText;
    @NotNull
    String crs;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="minx", column=@Column(name="initial_minx")), @AttributeOverride(name="maxx", column=@Column(name="initial_maxx")), @AttributeOverride(name="miny", column=@Column(name="initial_miny")), @AttributeOverride(name="maxy", column=@Column(name="initial_maxy"))})
    Bounds initialExtent;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="minx", column=@Column(name="max_minx")), @AttributeOverride(name="maxx", column=@Column(name="max_maxx")), @AttributeOverride(name="miny", column=@Column(name="max_miny")), @AttributeOverride(name="maxy", column=@Column(name="max_maxy"))})
    Bounds maxExtent;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    AppContent contentRoot;
    @JsonIgnore
    transient AppContent oldContentRoot;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    AppSettings settings;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    List<Component> components;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    AppStyling styling;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    @NotNull
    List<AuthorizationRule> authorizationRules;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Application() {
        this.$$_hibernate_write_contentRoot(new AppContent());
        this.$$_hibernate_write_settings(new AppSettings());
        this.$$_hibernate_write_components(new ArrayList());
        this.$$_hibernate_write_styling(new AppStyling());
        this.$$_hibernate_write_authorizationRules(new ArrayList());
    }

    public Long getId() {
        return this.$$_hibernate_read_id();
    }

    public Application setId(Long id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public Application setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public Application setName(String name) {
        this.$$_hibernate_write_name(name);
        return this;
    }

    public String getTitle() {
        return this.$$_hibernate_read_title();
    }

    public Application setTitle(String title) {
        this.$$_hibernate_write_title(title);
        return this;
    }

    public String getAdminComments() {
        return this.$$_hibernate_read_adminComments();
    }

    public Application setAdminComments(String adminComments) {
        this.$$_hibernate_write_adminComments(adminComments);
        return this;
    }

    public String getPreviewText() {
        return this.$$_hibernate_read_previewText();
    }

    public Application setPreviewText(String previewText) {
        this.$$_hibernate_write_previewText(previewText);
        return this;
    }

    public String getCrs() {
        return this.$$_hibernate_read_crs();
    }

    public Application setCrs(String crs) {
        this.$$_hibernate_write_crs(crs);
        return this;
    }

    public Bounds getInitialExtent() {
        return this.$$_hibernate_read_initialExtent();
    }

    public Application setInitialExtent(Bounds initialExtent) {
        this.$$_hibernate_write_initialExtent(initialExtent);
        return this;
    }

    public Bounds getMaxExtent() {
        return this.$$_hibernate_read_maxExtent();
    }

    public Application setMaxExtent(Bounds maxExtent) {
        this.$$_hibernate_write_maxExtent(maxExtent);
        return this;
    }

    public AppContent getContentRoot() {
        return this.$$_hibernate_read_contentRoot();
    }

    public Application setContentRoot(AppContent contentRoot) {
        this.$$_hibernate_write_oldContentRoot(this.$$_hibernate_read_contentRoot());
        this.$$_hibernate_write_contentRoot(contentRoot);
        return this;
    }

    public AppContent getOldContentRoot() {
        return this.$$_hibernate_read_oldContentRoot();
    }

    public AppSettings getSettings() {
        return this.$$_hibernate_read_settings();
    }

    public Application setSettings(AppSettings layerSettings) {
        this.$$_hibernate_write_settings(layerSettings);
        return this;
    }

    public List<Component> getComponents() {
        return this.$$_hibernate_read_components();
    }

    public Application setComponents(List<Component> components) {
        this.$$_hibernate_write_components(components);
        return this;
    }

    public AppStyling getStyling() {
        return this.$$_hibernate_read_styling();
    }

    public Application setStyling(AppStyling styling) {
        this.$$_hibernate_write_styling(styling);
        return this;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.$$_hibernate_read_authorizationRules();
    }

    public Application setAuthorizationRules(List<AuthorizationRule> authorizationRules) {
        this.$$_hibernate_write_authorizationRules(authorizationRules);
        return this;
    }

    @JsonIgnore
    public Stream<AppTreeLayerNode> getAllOldAppTreeLayerNode() {
        return this.getAppTreeLayerNodeStream(this.getOldContentRoot());
    }

    @JsonIgnore
    public Stream<AppTreeLayerNode> getAllAppTreeLayerNode() {
        return this.getAppTreeLayerNodeStream(this.getContentRoot());
    }

    @JsonIgnore
    private Stream<AppTreeLayerNode> getAppTreeLayerNodeStream(AppContent contentRoot) {
        if (contentRoot == null) {
            return Stream.empty();
        }
        Stream<Object> baseLayers = Stream.empty();
        if (contentRoot.getBaseLayerNodes() != null) {
            baseLayers = contentRoot.getBaseLayerNodes().stream().filter(n -> "AppTreeLayerNode".equals(n.getObjectType())).map(n -> (AppTreeLayerNode)n);
        }
        Stream<Object> layers = Stream.empty();
        if (contentRoot.getLayerNodes() != null) {
            layers = contentRoot.getLayerNodes().stream().filter(n -> "AppTreeLayerNode".equals(n.getObjectType())).map(n -> (AppTreeLayerNode)n);
        }
        return Stream.concat(baseLayers, layers);
    }

    @JsonIgnore
    public CoordinateReferenceSystem getGeoToolsCoordinateReferenceSystem() {
        CoordinateReferenceSystem gtCrs = null;
        try {
            if (this.getCrs() != null) {
                gtCrs = CRS.decode((String)this.getCrs());
            }
        }
        catch (Exception e) {
            String message = String.format("Application %d: error decoding CRS from code \"%s\": %s: %s", this.getId(), this.getCrs(), e.getClass(), e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.error(message, (Throwable)e);
            }
            logger.error(message);
        }
        return gtCrs;
    }

    @NotNull
    public AppLayerSettings getAppLayerSettings(@NotNull AppTreeLayerNode node) {
        return Optional.ofNullable(this.getSettings()).map(AppSettings::getLayerSettings).map(layerSettingsMap -> (AppLayerSettings)layerSettingsMap.get(node.getId())).orElseGet(AppLayerSettings::new);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Application application = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block4: {
            int n2;
            block5: {
                Application application = this;
                Application application2 = application;
                n2 = 0;
                if (n2 == 0 && application.$$_hibernate_collectionTracker != null) {
                    int n3 = application.$$_hibernate_collectionTracker.getSize("components");
                    if (application.components == null && n3 != -1) {
                        n2 = 1;
                    } else if (application.components != null && (!(application.components instanceof PersistentCollection) || ((PersistentCollection)application.components).wasInitialized()) && n3 != application.components.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block4;
                n2 = this.$$_hibernate_collectionTracker.getSize("authorizationRules");
                if (this.authorizationRules != null || n2 == -1) break block5;
                n = 1;
                break block4;
            }
            if (this.authorizationRules == null || this.authorizationRules instanceof PersistentCollection && !((PersistentCollection)this.authorizationRules).wasInitialized() || n2 == this.authorizationRules.size()) break block4;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block4: {
            int n;
            block5: {
                Application application = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                Application application2 = application;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                if (application.$$_hibernate_collectionTracker != null) {
                    int n2 = application.$$_hibernate_collectionTracker.getSize("components");
                    if (application.components == null && n2 != -1) {
                        dirtyTracker2.add("components");
                    } else if (application.components != null && (!(application.components instanceof PersistentCollection) || ((PersistentCollection)application.components).wasInitialized()) && n2 != application.components.size()) {
                        dirtyTracker2.add("components");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block4;
                n = this.$$_hibernate_collectionTracker.getSize("authorizationRules");
                if (this.authorizationRules != null || n == -1) break block5;
                dirtyTracker.add("authorizationRules");
                break block4;
            }
            if (this.authorizationRules == null || this.authorizationRules instanceof PersistentCollection && !((PersistentCollection)this.authorizationRules).wasInitialized() || n == this.authorizationRules.size()) break block4;
            dirtyTracker.add("authorizationRules");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block6: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Application application = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            Application application2 = application;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("components")) {
                if (application.components == null || application.components instanceof PersistentCollection && !((PersistentCollection)application.components).wasInitialized()) {
                    application.$$_hibernate_collectionTracker.add("components", -1);
                } else {
                    application.$$_hibernate_collectionTracker.add("components", application.components.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("authorizationRules")) break block6;
            if (this.authorizationRules == null || this.authorizationRules instanceof PersistentCollection && !((PersistentCollection)this.authorizationRules).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("authorizationRules", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("authorizationRules", this.authorizationRules.size());
            }
        }
    }

    public Long $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(Long l) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)l);
            return;
        }
        this.id = l;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_title() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "title", (Object)this.title);
        }
        return this.title;
    }

    public void $$_hibernate_write_title(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"title", (Object)string, (Object)this.title)) {
            this.$$_hibernate_trackChange("title");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.title = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "title", (Object)this.title, (Object)string);
            return;
        }
        this.title = string;
    }

    public String $$_hibernate_read_adminComments() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminComments = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "adminComments", (Object)this.adminComments);
        }
        return this.adminComments;
    }

    public void $$_hibernate_write_adminComments(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"adminComments", (Object)string, (Object)this.adminComments)) {
            this.$$_hibernate_trackChange("adminComments");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminComments = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "adminComments", (Object)this.adminComments, (Object)string);
            return;
        }
        this.adminComments = string;
    }

    public String $$_hibernate_read_previewText() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.previewText = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "previewText", (Object)this.previewText);
        }
        return this.previewText;
    }

    public void $$_hibernate_write_previewText(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"previewText", (Object)string, (Object)this.previewText)) {
            this.$$_hibernate_trackChange("previewText");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.previewText = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "previewText", (Object)this.previewText, (Object)string);
            return;
        }
        this.previewText = string;
    }

    public String $$_hibernate_read_crs() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.crs = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "crs", (Object)this.crs);
        }
        return this.crs;
    }

    public void $$_hibernate_write_crs(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"crs", (Object)string, (Object)this.crs)) {
            this.$$_hibernate_trackChange("crs");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.crs = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "crs", (Object)this.crs, (Object)string);
            return;
        }
        this.crs = string;
    }

    public Bounds $$_hibernate_read_initialExtent() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.initialExtent = (Bounds)this.$$_hibernate_getInterceptor().readObject((Object)this, "initialExtent", (Object)this.initialExtent);
        }
        return this.initialExtent;
    }

    public void $$_hibernate_write_initialExtent(Bounds bounds) {
        if (this.initialExtent != null) {
            ManagedTypeHelper.asCompositeTracker((Object)this.initialExtent).$$_hibernate_clearOwner("initialExtent");
        }
        Application application = this;
        Bounds bounds2 = bounds;
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)application, (String)"initialExtent", (Object)bounds2, (Object)application.initialExtent)) {
            application.$$_hibernate_trackChange("initialExtent");
        }
        application.initialExtent = application.$$_hibernate_getInterceptor() != null ? (Bounds)application.$$_hibernate_getInterceptor().writeObject((Object)application, "initialExtent", (Object)application.initialExtent, (Object)bounds2) : bounds2;
        if (this.initialExtent != null) {
            ManagedTypeHelper.asCompositeTracker((Object)this.initialExtent).$$_hibernate_setOwner("initialExtent", (CompositeOwner)this);
        }
        this.$$_hibernate_trackChange("initialExtent");
    }

    public Bounds $$_hibernate_read_maxExtent() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.maxExtent = (Bounds)this.$$_hibernate_getInterceptor().readObject((Object)this, "maxExtent", (Object)this.maxExtent);
        }
        return this.maxExtent;
    }

    public void $$_hibernate_write_maxExtent(Bounds bounds) {
        if (this.maxExtent != null) {
            ManagedTypeHelper.asCompositeTracker((Object)this.maxExtent).$$_hibernate_clearOwner("maxExtent");
        }
        Application application = this;
        Bounds bounds2 = bounds;
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)application, (String)"maxExtent", (Object)bounds2, (Object)application.maxExtent)) {
            application.$$_hibernate_trackChange("maxExtent");
        }
        application.maxExtent = application.$$_hibernate_getInterceptor() != null ? (Bounds)application.$$_hibernate_getInterceptor().writeObject((Object)application, "maxExtent", (Object)application.maxExtent, (Object)bounds2) : bounds2;
        if (this.maxExtent != null) {
            ManagedTypeHelper.asCompositeTracker((Object)this.maxExtent).$$_hibernate_setOwner("maxExtent", (CompositeOwner)this);
        }
        this.$$_hibernate_trackChange("maxExtent");
    }

    public AppContent $$_hibernate_read_contentRoot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contentRoot = (AppContent)this.$$_hibernate_getInterceptor().readObject((Object)this, "contentRoot", (Object)this.contentRoot);
        }
        return this.contentRoot;
    }

    public void $$_hibernate_write_contentRoot(AppContent appContent) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"contentRoot", (Object)appContent, (Object)this.contentRoot)) {
            this.$$_hibernate_trackChange("contentRoot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.contentRoot = (AppContent)this.$$_hibernate_getInterceptor().writeObject((Object)this, "contentRoot", (Object)this.contentRoot, (Object)appContent);
            return;
        }
        this.contentRoot = appContent;
    }

    public AppContent $$_hibernate_read_oldContentRoot() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.oldContentRoot = (AppContent)this.$$_hibernate_getInterceptor().readObject((Object)this, "oldContentRoot", (Object)this.oldContentRoot);
        }
        return this.oldContentRoot;
    }

    public void $$_hibernate_write_oldContentRoot(AppContent appContent) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"oldContentRoot", (Object)appContent, (Object)this.oldContentRoot)) {
            this.$$_hibernate_trackChange("oldContentRoot");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.oldContentRoot = (AppContent)this.$$_hibernate_getInterceptor().writeObject((Object)this, "oldContentRoot", (Object)this.oldContentRoot, (Object)appContent);
            return;
        }
        this.oldContentRoot = appContent;
    }

    public AppSettings $$_hibernate_read_settings() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (AppSettings)this.$$_hibernate_getInterceptor().readObject((Object)this, "settings", (Object)this.settings);
        }
        return this.settings;
    }

    public void $$_hibernate_write_settings(AppSettings appSettings) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"settings", (Object)appSettings, (Object)this.settings)) {
            this.$$_hibernate_trackChange("settings");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.settings = (AppSettings)this.$$_hibernate_getInterceptor().writeObject((Object)this, "settings", (Object)this.settings, (Object)appSettings);
            return;
        }
        this.settings = appSettings;
    }

    public List $$_hibernate_read_components() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.components = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "components", this.components);
        }
        return this.components;
    }

    public void $$_hibernate_write_components(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.components = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "components", this.components, (Object)list);
            return;
        }
        this.components = list;
    }

    public AppStyling $$_hibernate_read_styling() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.styling = (AppStyling)this.$$_hibernate_getInterceptor().readObject((Object)this, "styling", (Object)this.styling);
        }
        return this.styling;
    }

    public void $$_hibernate_write_styling(AppStyling appStyling) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"styling", (Object)appStyling, (Object)this.styling)) {
            this.$$_hibernate_trackChange("styling");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.styling = (AppStyling)this.$$_hibernate_getInterceptor().writeObject((Object)this, "styling", (Object)this.styling, (Object)appStyling);
            return;
        }
        this.styling = appStyling;
    }

    public List $$_hibernate_read_authorizationRules() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authorizationRules = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "authorizationRules", this.authorizationRules);
        }
        return this.authorizationRules;
    }

    public void $$_hibernate_write_authorizationRules(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authorizationRules = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authorizationRules", this.authorizationRules, (Object)list);
            return;
        }
        this.authorizationRules = list;
    }
}

