/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository;

import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.annotation.RepositoryRestResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.tailormap.api.persistence.Configuration;
import org.tailormap.api.security.annotation.PreAuthorizeAdmin;

@PreAuthorizeAdmin
@RepositoryRestResource(path="configs", collectionResourceRel="configs", itemResourceRel="config")
public interface ConfigurationRepository
extends JpaRepository<Configuration, String> {
    @PreAuthorize(value="permitAll()")
    public Optional<Configuration> findByKey(String var1);

    @PreAuthorize(value="permitAll()")
    default public String get(String key) {
        return this.get(key, null);
    }

    @PreAuthorize(value="permitAll()")
    default public String get(String key, String defaultValue) {
        return this.findByKey(key).map(Configuration::getValue).orElse(defaultValue);
    }

    @PreAuthorize(value="permitAll()")
    @Query(value="from Configuration c where c.key = :key and c.availableForViewer = true")
    public Optional<Configuration> getAvailableForViewer(@Param(value="key") String var1);

    public void deleteConfigurationByKey(String var1);
}

