/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import java.lang.invoke.MethodHandles;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DebugLoggingJobListener
implements JobListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Job {}:{} about to be executed.", (Object)context.getJobDetail().getKey().getGroup(), (Object)context.getJobDetail().getKey().getName());
            logger.debug("Job data map before execution: {}", (Object)context.getMergedJobDataMap().getWrappedMap());
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Job {}:{} execution vetoed.", (Object)context.getJobDetail().getKey().getGroup(), (Object)context.getJobDetail().getKey().getName());
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (logger.isDebugEnabled()) {
            logger.debug("Job {}:{} was executed in: {} ms. With result: {}", new Object[]{context.getJobDetail().getKey().getGroup(), context.getJobDetail().getKey().getName(), context.getJobRunTime(), context.getResult()});
        }
        if (null != jobException && logger.isDebugEnabled()) {
            logger.error("Job {}:{} threw an exception: {}", new Object[]{context.getJobDetail().getKey().getGroup(), context.getJobDetail().getKey().getName(), jobException.getMessage()});
        }
    }
}

