/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Service;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.security.TailormapAdditionalProperty;
import org.tailormap.api.security.TailormapOidcUser;

@Service
public class TailormapOidcUserService
extends OidcUserService {
    private final GroupRepository groupRepository;

    public TailormapOidcUserService(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        ArrayList<String> groups = new ArrayList<String>();
        Optional.ofNullable(userRequest.getIdToken().getClaimAsStringList("roles")).ifPresent(groups::addAll);
        Set<String> aliases = this.groupRepository.findAliasesForGroups(groups);
        groups.addAll(aliases);
        List<TailormapAdditionalProperty> groupProperties = this.groupRepository.findAdditionalPropertiesByGroups(groups);
        ArrayList authorities = new ArrayList(user.getAuthorities());
        groups.stream().map(SimpleGrantedAuthority::new).forEach(authorities::add);
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        String oidcRegistrationName = userRequest.getClientRegistration().getClientName();
        return new TailormapOidcUser(authorities, user.getIdToken(), user.getUserInfo(), userNameAttributeName, oidcRegistrationName, groupProperties);
    }
}

