/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class TaskSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID uuid = null;
    private String description = null;
    private String cronExpression;
    private Integer priority = null;

    public TaskSchedule uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @Valid
    @Schema(name="uuid", accessMode=Schema.AccessMode.READ_ONLY, description="UUID of the task; this is the unique identifier of the task", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public TaskSchedule description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Human-readable description of the task.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaskSchedule cronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @NotNull
    @Schema(name="cronExpression", description="Cron expression for the task", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="cronExpression")
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public TaskSchedule priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", description="Priority of the task", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSchedule taskSchedule = (TaskSchedule)o;
        return Objects.equals(this.uuid, taskSchedule.uuid) && Objects.equals(this.description, taskSchedule.description) && Objects.equals(this.cronExpression, taskSchedule.cronExpression) && Objects.equals(this.priority, taskSchedule.priority);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.description, this.cronExpression, this.priority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskSchedule {\n");
        sb.append("    uuid: ").append(this.toIndentedString((Object)this.uuid)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    cronExpression: ").append(this.toIndentedString((Object)this.cronExpression)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

