/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration;

import ch.rasc.sse.eventbus.config.EnableSseEventBus;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="tailormap-api")
@EnableSseEventBus
@EnableScheduling
public class TailormapConfig {
    private int timeout;
    @Value(value="${tailormap-api.default-language:en}")
    private String defaultLanguage;

    public int getTimeout() {
        return this.timeout;
    }

    public TailormapConfig setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Bean
    public LocaleResolver localeResolver() {
        AcceptHeaderLocaleResolver resolver = new AcceptHeaderLocaleResolver();
        resolver.setDefaultLocale(Locale.of(this.defaultLanguage));
        return resolver;
    }
}

