/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import com.google.common.base.Splitter;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.geotools.featuresources.AttachmentsHelper;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AttachmentAttributeType;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.util.EditUtil;
import org.tailormap.api.viewer.model.AttachmentMetadata;

/*
 * Exception performing whole class analysis ignored.
 */
@AppRestController
@Validated
public class AttachmentsController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final EditUtil editUtil;
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public AttachmentsController(EditUtil editUtil, FeatureSourceFactoryHelper featureSourceFactoryHelper) {
        this.editUtil = editUtil;
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @PostMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/feature/{featureId}/attachments"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<Serializable> addAttachment(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable String featureId, @RequestPart(value="attachmentMetadata") AttachmentMetadata attachment, @RequestPart(value="attachment") byte[] fileData) {
        AttachmentMetadata response;
        this.editUtil.checkEditAuthorisation();
        TMFeatureType tmFeatureType = this.editUtil.getEditableFeatureType(application, appTreeLayerNode, service, layer);
        Object primaryKey = this.getFeaturePrimaryKeyByFid(tmFeatureType, featureId);
        @Valid Set attachmentAttrSet = tmFeatureType.getSettings().getAttachmentAttributes();
        if (attachmentAttrSet == null || attachmentAttrSet.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not support attachments");
        }
        AttachmentAttributeType attachmentAttribute = attachmentAttrSet.stream().filter(attr -> attr.getAttributeName().equals(attachment.getAttributeName())).findFirst().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not support attachments for attribute " + attachment.getAttributeName()));
        if (attachmentAttribute.getMaxAttachmentSize() != null && attachmentAttribute.getMaxAttachmentSize() < (long)fileData.length) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Attachment size %d exceeds maximum of %d".formatted(fileData.length, attachmentAttribute.getMaxAttachmentSize()));
        }
        if (attachmentAttribute.getMimeType() != null && !AttachmentsController.validateMimeTypeAccept((String)attachmentAttribute.getMimeType(), (String)attachment.getFileName(), (String)attachment.getMimeType())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "File type or extension not allowed");
        }
        logger.debug("Using attachment attribute {}", (Object)attachmentAttribute);
        try {
            response = AttachmentsHelper.insertAttachment((TMFeatureType)tmFeatureType, (AttachmentMetadata)attachment, (Object)primaryKey, (byte[])fileData);
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
    }

    private static boolean validateMimeTypeAccept(String acceptList, String fileName, String mimeType) {
        Iterable allowedMimeTypes = Splitter.on((Pattern)Pattern.compile(",\\s*")).split((CharSequence)acceptList);
        Locale locale = Locale.ENGLISH;
        for (String allowedType : allowedMimeTypes) {
            String category;
            if (!(allowedType.startsWith(".") ? fileName.toLowerCase(locale).endsWith(allowedType.toLowerCase(locale)) : (allowedType.endsWith("/*") ? mimeType.startsWith(category = allowedType.substring(0, allowedType.length() - 1)) : mimeType.equals(allowedType)))) continue;
            return true;
        }
        return false;
    }

    @GetMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/feature/{featureId}/attachments"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<List<AttachmentMetadata>> listAttachments(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable String featureId) {
        List response;
        TMFeatureType tmFeatureType = this.editUtil.getEditableFeatureType(application, appTreeLayerNode, service, layer);
        this.checkFeatureTypeSupportsAttachments(tmFeatureType);
        Object primaryKey = this.getFeaturePrimaryKeyByFid(tmFeatureType, featureId);
        try {
            response = AttachmentsHelper.listAttachmentsForFeature((TMFeatureType)tmFeatureType, (Object)primaryKey);
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/attachment/{attachmentId}"})
    @Transactional
    public ResponseEntity<Serializable> deleteAttachment(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable UUID attachmentId) {
        this.editUtil.checkEditAuthorisation();
        TMFeatureType tmFeatureType = this.editUtil.getEditableFeatureType(application, appTreeLayerNode, service, layer);
        this.checkFeatureTypeSupportsAttachments(tmFeatureType);
        try {
            AttachmentsHelper.deleteAttachment((UUID)attachmentId, (TMFeatureType)tmFeatureType);
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @Transactional
    @GetMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/attachment/{attachmentId}"}, produces={"application/octet-stream"})
    public ResponseEntity<byte[]> getAttachment(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @PathVariable UUID attachmentId) {
        TMFeatureType tmFeatureType = this.editUtil.getEditableFeatureType(application, appTreeLayerNode, service, layer);
        try {
            AttachmentsHelper.AttachmentWithBinary attachmentWithBinary = AttachmentsHelper.getAttachment((TMFeatureType)tmFeatureType, (UUID)attachmentId);
            if (attachmentWithBinary == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Attachment %s not found".formatted(attachmentId.toString()));
            }
            ByteBuffer bb = attachmentWithBinary.attachment().asReadOnlyBuffer();
            bb.rewind();
            byte[] attachmentData = new byte[bb.remaining()];
            bb.get(attachmentData);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"inline; filename=\"" + attachmentWithBinary.attachmentMetadata().getFileName() + "\""})).contentType(MediaType.parseMediaType((String)attachmentWithBinary.attachmentMetadata().getMimeType())).body((Object)attachmentData);
        }
        catch (IOException | SQLException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private Object getFeaturePrimaryKeyByFid(TMFeatureType tmFeatureType, String featureId) throws ResponseStatusException {
        Id fidFilter = this.ff.id(new FeatureId[]{this.ff.featureId(featureId)});
        SimpleFeatureSource fs = null;
        try {
            Object object;
            block13: {
                fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
                Query query = new Query();
                query.setFilter((Filter)fidFilter);
                query.setPropertyNames(new String[]{tmFeatureType.getPrimaryKeyAttribute()});
                SimpleFeatureIterator sfi = fs.getFeatures(query).features();
                try {
                    if (!sfi.hasNext()) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Feature with id %s does not exist".formatted(featureId));
                    }
                    object = ((SimpleFeature)sfi.next()).getAttribute(tmFeatureType.getPrimaryKeyAttribute());
                    if (sfi == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (sfi != null) {
                            try {
                                sfi.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
                    }
                }
                sfi.close();
            }
            return object;
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void checkFeatureTypeSupportsAttachments(TMFeatureType tmFeatureType) throws ResponseStatusException {
        @Valid Set attachmentAttrSet = tmFeatureType.getSettings().getAttachmentAttributes();
        if (attachmentAttrSet == null || attachmentAttrSet.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not support attachments");
        }
    }
}

