/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Metrics;
import java.util.Locale;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.helper.ApplicationHelper;
import org.tailormap.api.persistence.helper.UploadHelper;
import org.tailormap.api.persistence.helper.ViewerResponseHelper;
import org.tailormap.api.prometheus.TagNames;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;
import org.tailormap.api.security.AuthorisationService;
import org.tailormap.api.viewer.model.AppStyling;
import org.tailormap.api.viewer.model.MapResponse;
import org.tailormap.api.viewer.model.ViewerResponse;

@AppRestController
public class ViewerController
implements TagNames {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationHelper applicationHelper;
    private final AuthorisationService authorisationService;
    private final UploadHelper uploadHelper;
    private final ViewerResponseHelper viewerResponseHelper;

    public ViewerController(ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, ApplicationHelper applicationHelper, AuthorisationService authorisationService, UploadHelper uploadHelper, ViewerResponseHelper viewerResponseHelper) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.applicationHelper = applicationHelper;
        this.authorisationService = authorisationService;
        this.uploadHelper = uploadHelper;
        this.viewerResponseHelper = viewerResponseHelper;
    }

    @GetMapping(path={"${tailormap-api.base-path}/app"})
    @Timed(value="get_default_app", description="Get default app")
    @Counted(value="get_default_app", description="Count of get default app")
    public ViewerResponse defaultApp() {
        String defaultAppName = this.configurationRepository.get("default-app");
        Application app = this.applicationRepository.findByName(defaultAppName);
        if (app == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (!this.authorisationService.userAllowedToViewApplication(app)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.viewer(app, ViewerResponse.KindEnum.APP);
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}", "${tailormap-api.base-path}/service/{viewerName}"})
    @Timed(value="get_named_app", description="Get named app")
    @Counted(value="get_named_app", description="Count of get named app")
    public ViewerResponse viewer(@ModelAttribute Application app, @ModelAttribute ViewerResponse.KindEnum viewerKind) {
        ViewerResponse viewerResponse = this.viewerResponseHelper.getViewerResponse(app).kind(viewerKind);
        AppStyling styling = viewerResponse.getStyling();
        if (styling != null) {
            styling.setLogo(this.uploadHelper.getUrlForImage(styling.getLogo(), "app-logo"));
        }
        Metrics.counter((String)"tailormap_app_request", (String[])new String[]{"appType", viewerKind.name().toLowerCase(Locale.getDefault()), "appName", app.getName(), "appId", app.getId().toString()}).increment();
        return viewerResponse;
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}/map", "${tailormap-api.base-path}/service/{viewerName}/map"})
    public MapResponse map(@ModelAttribute Application app) {
        MapResponse mapResponse = this.applicationHelper.toMapResponse(app);
        mapResponse.getAppLayers().stream().filter(l -> l.getLegendImageUrl() != null && l.getLegendImageUrl().matches("(?i)^[\\da-f]{8}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{12}$")).forEach(l -> l.setLegendImageUrl(this.uploadHelper.getUrlForImage(l.getLegendImageUrl(), "legend")));
        return mapResponse;
    }
}

